/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.tries.IncrementalTrieWriter;
import org.apache.cassandra.io.tries.IncrementalTrieWriterBase;
import org.apache.cassandra.io.tries.TrieNode;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;

@NotThreadSafe
public class IncrementalTrieWriterPageAware<VALUE>
extends IncrementalTrieWriterBase<VALUE, DataOutputPlus, Node<VALUE>>
implements IncrementalTrieWriter<VALUE> {
    final int maxBytesPerPage;
    private static final Comparator<Node<?>> BRANCH_SIZE_COMPARATOR = (l, r) -> {
        int c = Integer.compare(l.branchSize + l.nodeSize, r.branchSize + r.nodeSize);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(l.transition, r.transition);
        assert (c != 0 || l == r);
        return c;
    };

    IncrementalTrieWriterPageAware(TrieSerializer<VALUE, ? super DataOutputPlus> trieSerializer, DataOutputPlus dest) {
        super(trieSerializer, dest, new Node(0));
        this.maxBytesPerPage = dest.maxBytesInPage();
    }

    @Override
    public void reset() {
        this.reset(new Node(0));
    }

    @Override
    Node<VALUE> performCompletion() throws IOException {
        int bytesLeft;
        Node root = (Node)super.performCompletion();
        int actualSize = this.recalcTotalSize(root, ((DataOutputPlus)this.dest).position());
        if (actualSize > (bytesLeft = ((DataOutputPlus)this.dest).bytesLeftInPage())) {
            if (actualSize <= this.maxBytesPerPage) {
                ((DataOutputPlus)this.dest).padToPageBoundary();
                bytesLeft = this.maxBytesPerPage;
                actualSize = this.recalcTotalSize(root, ((DataOutputPlus)this.dest).position());
            }
            if (actualSize > bytesLeft) {
                this.layoutChildren(root);
                if (root.nodeSize > ((DataOutputPlus)this.dest).bytesLeftInPage()) {
                    ((DataOutputPlus)this.dest).padToPageBoundary();
                    this.recalcTotalSize(root, ((DataOutputPlus)this.dest).position());
                }
            }
        }
        root.finalizeWithPosition(this.write(root));
        return root;
    }

    @Override
    void complete(Node<VALUE> node) throws IOException {
        assert (node.filePos == -1L);
        int branchSize = 0;
        for (Node child : node.children) {
            branchSize += child.branchSize + child.nodeSize;
        }
        node.branchSize = branchSize;
        int nodeSize = this.serializer.sizeofNode(node, ((DataOutputPlus)this.dest).position());
        if (nodeSize + branchSize < this.maxBytesPerPage) {
            node.nodeSize = nodeSize;
            node.hasOutOfPageChildren = false;
            node.hasOutOfPageInBranch = false;
            for (Node child : node.children) {
                if (child.filePos != -1L) {
                    node.hasOutOfPageChildren = true;
                    continue;
                }
                if (!child.hasOutOfPageChildren && !child.hasOutOfPageInBranch) continue;
                node.hasOutOfPageInBranch = true;
            }
            return;
        }
        this.layoutChildren(node);
    }

    private void layoutChildren(Node<VALUE> node) throws IOException {
        assert (node.filePos == -1L);
        NavigableSet<Node<VALUE>> children = node.getChildrenWithUnsetPosition();
        int bytesLeft = ((DataOutputPlus)this.dest).bytesLeftInPage();
        Node cmp = new Node(256);
        cmp.nodeSize = 0;
        while (!children.isEmpty()) {
            int actualSize;
            cmp.branchSize = bytesLeft;
            Node<Object> child = children.headSet(cmp, true).pollLast();
            if (child == null) {
                ((DataOutputPlus)this.dest).padToPageBoundary();
                bytesLeft = this.maxBytesPerPage;
                child = children.pollLast();
            }
            assert (child != null);
            if ((child.hasOutOfPageChildren || child.hasOutOfPageInBranch) && (actualSize = this.recalcTotalSize(child, ((DataOutputPlus)this.dest).position())) > bytesLeft) {
                if (bytesLeft == this.maxBytesPerPage) {
                    this.layoutChildren(child);
                    bytesLeft = ((DataOutputPlus)this.dest).bytesLeftInPage();
                    assert (child.filePos == -1L);
                }
                children.add(child);
                continue;
            }
            child.finalizeWithPosition(this.write(child));
            bytesLeft = ((DataOutputPlus)this.dest).bytesLeftInPage();
        }
        node.branchSize = 0;
        node.hasOutOfPageChildren = true;
        node.hasOutOfPageInBranch = false;
        node.nodeSize = this.serializer.sizeofNode(node, ((DataOutputPlus)this.dest).position());
    }

    protected int recalcTotalSize(Node<VALUE> node, long nodePosition) throws IOException {
        if (node.hasOutOfPageInBranch) {
            int sz = 0;
            for (Node child : node.children) {
                sz += this.recalcTotalSize(child, nodePosition + (long)sz);
            }
            node.branchSize = sz;
        }
        if (node.hasOutOfPageChildren || node.hasOutOfPageInBranch) {
            node.nodeSize = this.serializer.sizeofNode(node, nodePosition + (long)node.branchSize);
        }
        return node.branchSize + node.nodeSize;
    }

    protected long write(Node<VALUE> node) throws IOException {
        long nodePosition = ((DataOutputPlus)this.dest).position();
        for (Node child : node.children) {
            if (child.filePos != -1L) continue;
            child.filePos = this.write(child);
        }
        assert (((DataOutputPlus)this.dest).position() == (nodePosition += (long)node.branchSize)) : "Expected node position to be " + nodePosition + " but got " + ((DataOutputPlus)this.dest).position() + " after writing children.\n" + this.dumpNode(node, ((DataOutputPlus)this.dest).position());
        this.serializer.write(this.dest, node, nodePosition);
        assert (((DataOutputPlus)this.dest).position() == nodePosition + (long)node.nodeSize || ((DataOutputPlus)this.dest).paddedPosition() == ((DataOutputPlus)this.dest).position()) : "Expected node position to be " + (nodePosition + (long)node.nodeSize) + " but got " + ((DataOutputPlus)this.dest).position() + " after writing node, nodeSize " + node.nodeSize + ".\n" + this.dumpNode(node, nodePosition);
        return nodePosition;
    }

    protected String dumpNode(Node<VALUE> node, long nodePosition) {
        StringBuilder res = new StringBuilder(String.format("At %,d(%x) type %s child count %s nodeSize %,d branchSize %,d %s%s%n", nodePosition, nodePosition, TrieNode.typeFor(node, nodePosition), node.childCount(), node.nodeSize, node.branchSize, node.hasOutOfPageChildren ? "C" : "", node.hasOutOfPageInBranch ? "B" : ""));
        for (Node child : node.children) {
            res.append(String.format("Child %2x at %,d(%x) type %s child count %s size %s nodeSize %,d branchSize %,d %s%s%n", child.transition & 0xFF, child.filePos, child.filePos, child.children != null ? TrieNode.typeFor(child, child.filePos) : "n/a", child.children != null ? Integer.valueOf(child.childCount()) : "n/a", child.children != null ? Integer.valueOf(this.serializer.sizeofNode(child, child.filePos)) : "n/a", child.nodeSize, child.branchSize, child.hasOutOfPageChildren ? "C" : "", child.hasOutOfPageInBranch ? "B" : ""));
        }
        return res.toString();
    }

    @Override
    public IncrementalTrieWriter.PartialTail makePartialRoot() throws IOException {
        try (DataOutputBuffer buf = new DataOutputBuffer();){
            IncrementalTrieWriterBase.PTail tail = new IncrementalTrieWriterBase.PTail();
            tail.cutoff = ((DataOutputPlus)this.dest).paddedPosition();
            tail.count = this.count;
            tail.root = this.writePartial((Node)this.stack.getFirst(), buf, tail.cutoff);
            tail.tail = buf.asNewBuffer();
            IncrementalTrieWriterBase.PTail pTail = tail;
            return pTail;
        }
    }

    protected long writePartial(Node<VALUE> node, DataOutputPlus dest, long baseOffset) throws IOException {
        long startPosition = dest.position() + baseOffset;
        ArrayList<Node> childrenToClear = new ArrayList<Node>();
        for (Node child : node.children) {
            if (child.filePos != -1L) continue;
            childrenToClear.add(child);
            child.filePos = this.writePartial(child, dest, baseOffset);
        }
        long nodePosition = dest.position() + baseOffset;
        if (node.hasOutOfPageInBranch) {
            node.branchSize = (int)(nodePosition - startPosition);
        }
        this.serializer.write(dest, node, nodePosition);
        if (node.hasOutOfPageChildren || node.hasOutOfPageInBranch) {
            long endPosition = dest.position() + baseOffset;
            node.nodeSize = (int)(endPosition - nodePosition);
        }
        for (Node child : childrenToClear) {
            child.filePos = -1L;
        }
        return nodePosition;
    }

    static class Node<Value>
    extends IncrementalTrieWriterBase.BaseNode<Value, Node<Value>> {
        int branchSize = -1;
        int nodeSize = -1;
        boolean hasOutOfPageInBranch = false;
        boolean hasOutOfPageChildren = true;

        Node(int transition) {
            super(transition);
        }

        @Override
        Node<Value> newNode(byte transition) {
            return new Node<Value>(transition & 0xFF);
        }

        @Override
        public long serializedPositionDelta(int i, long nodePosition) {
            assert (((Node)this.children.get((int)i)).filePos != -1L);
            return ((Node)this.children.get((int)i)).filePos - nodePosition;
        }

        @Override
        public long maxPositionDelta(long nodePosition) {
            assert (this.childCount() > 0);
            if (!this.hasOutOfPageChildren) {
                return -(this.branchSize - ((Node)this.children.get((int)0)).branchSize);
            }
            long minPlaced = 0L;
            long minUnplaced = 1L;
            for (Node child : this.children) {
                if (child.filePos != -1L) {
                    minPlaced = Math.min(minPlaced, child.filePos - nodePosition);
                    continue;
                }
                if (minUnplaced <= 0L) continue;
                minUnplaced = -(this.branchSize - child.branchSize);
            }
            return Math.min(minPlaced, minUnplaced);
        }

        NavigableSet<Node<Value>> getChildrenWithUnsetPosition() {
            TreeSet<Node<Value>> result = new TreeSet<Node<Value>>(BRANCH_SIZE_COMPARATOR);
            for (Node child : this.children) {
                if (child.filePos != -1L) continue;
                result.add(child);
            }
            return result;
        }

        @Override
        void finalizeWithPosition(long position) {
            this.branchSize = 0;
            this.nodeSize = 0;
            this.hasOutOfPageInBranch = false;
            this.hasOutOfPageChildren = false;
            super.finalizeWithPosition(position);
        }

        @Override
        public String toString() {
            return String.format("%02x branchSize=%04x nodeSize=%04x %s%s", this.transition, this.branchSize, this.nodeSize, this.hasOutOfPageInBranch ? "B" : "", this.hasOutOfPageChildren ? "C" : "");
        }
    }
}

