/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteArrayUtil;

class CustomParamsSerializer
implements IVersionedSerializer<Map<String, byte[]>> {
    public static final CustomParamsSerializer serializer = new CustomParamsSerializer();

    CustomParamsSerializer() {
    }

    @Override
    public void serialize(Map<String, byte[]> t, DataOutputPlus out, int version) throws IOException {
        out.writeUnsignedVInt32(t.size());
        for (Map.Entry<String, byte[]> e : t.entrySet()) {
            out.writeUTF(e.getKey());
            ByteArrayUtil.writeWithVIntLength(e.getValue(), out);
        }
    }

    @Override
    public long serializedSize(Map<String, byte[]> t, int version) {
        int size = TypeSizes.sizeofUnsignedVInt(t.size());
        for (Map.Entry<String, byte[]> e : t.entrySet()) {
            size += TypeSizes.sizeof(e.getKey());
            size += ByteArrayUtil.serializedSizeWithVIntLength(e.getValue());
        }
        return size;
    }

    @Override
    public Map<String, byte[]> deserialize(DataInputPlus in, int version) throws IOException {
        int entries = in.readUnsignedVInt32();
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)entries);
        for (int i = 0; i < entries; ++i) {
            customParams.put(in.readUTF(), ByteArrayUtil.readWithVIntLength(in));
        }
        return customParams;
    }
}

