/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="listsnapshots", description="Lists all the snapshots along with the size on disk and true size. True size is the total size of all SSTables which are not backed up to disk. Size on disk is total size of the snapshot on disk. Total TrueDiskSpaceUsed does not make any SSTable deduplication.")
public class ListSnapshots
extends NodeTool.NodeToolCmd {
    @Option(title="no_ttl", name={"-nt", "--no-ttl"}, description="Skip snapshots with TTL")
    private boolean noTTL = false;
    @Option(title="ephemeral", name={"-e", "--ephemeral"}, description="Include ephememeral snapshots")
    private boolean includeEphemeral = false;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        try {
            out.println("Snapshot Details: ");
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("no_ttl", Boolean.toString(this.noTTL));
            options.put("include_ephemeral", Boolean.toString(this.includeEphemeral));
            Map<String, TabularData> snapshotDetails = probe.getSnapshotDetails(options);
            if (snapshotDetails.isEmpty()) {
                out.println("There are no snapshots");
                return;
            }
            long trueSnapshotsSize = probe.trueSnapshotsSize();
            TableBuilder table = new TableBuilder();
            List<String> indexNames = snapshotDetails.entrySet().iterator().next().getValue().getTabularType().getIndexNames();
            if (this.includeEphemeral) {
                table.add(indexNames.toArray(new String[indexNames.size()]));
            } else {
                table.add(indexNames.subList(0, indexNames.size() - 1).toArray(new String[indexNames.size() - 1]));
            }
            for (Map.Entry<String, TabularData> snapshotDetail : snapshotDetails.entrySet()) {
                Set<?> values = snapshotDetail.getValue().keySet();
                for (Object eachValue : values) {
                    List value = (List)eachValue;
                    if (this.includeEphemeral) {
                        table.add(value.toArray(new String[value.size()]));
                        continue;
                    }
                    table.add(value.subList(0, value.size() - 1).toArray(new String[value.size() - 1]));
                }
            }
            table.printTo(out);
            out.println("\nTotal TrueDiskSpaceUsed: " + FileUtils.stringifyFileSize(trueSnapshotsSize) + "\n");
        }
        catch (Exception e) {
            throw new RuntimeException("Error during list snapshot", e);
        }
    }
}

