/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class Threads {
    public static String prettyPrintStackTrace(Thread thread, boolean printBriefPackages, String delimiter) {
        return Threads.prettyPrint(thread.getStackTrace(), printBriefPackages, delimiter);
    }

    public static String prettyPrintStackTrace(Thread thread, boolean printBriefPackages, String prefix, String delimiter, String suffix) {
        return Threads.prettyPrint(thread.getStackTrace(), printBriefPackages, prefix, delimiter, suffix);
    }

    public static String prettyPrint(StackTraceElement[] st, boolean printBriefPackages, String delimiter) {
        return Threads.prettyPrint(st, printBriefPackages, "", delimiter, "");
    }

    public static String prettyPrint(StackTraceElement[] st, boolean printBriefPackages, String prefix, String delimiter, String suffix) {
        return Stream.of(st).collect(new StackTraceCombiner(printBriefPackages, prefix, delimiter, suffix));
    }

    public static String prettyPrint(Stream<StackTraceElement> st, boolean printBriefPackages, String prefix, String delimiter, String suffix) {
        return st.collect(new StackTraceCombiner(printBriefPackages, prefix, delimiter, suffix));
    }

    public static class StackTraceCombiner
    implements Collector<StackTraceElement, StringBuilder, String>,
    Supplier<StringBuilder>,
    Function<StringBuilder, String> {
        final boolean printBriefPackages;
        final String prefix;
        final String delimiter;
        final String suffix;

        public StackTraceCombiner(boolean printBriefPackages, String prefix, String delimiter, String suffix) {
            this.printBriefPackages = printBriefPackages;
            this.prefix = prefix;
            this.delimiter = delimiter;
            this.suffix = suffix;
        }

        @Override
        public Supplier<StringBuilder> supplier() {
            return this;
        }

        @Override
        public BiConsumer<StringBuilder, StackTraceElement> accumulator() {
            return (sb, ste) -> {
                if (sb.length() > this.prefix.length()) {
                    sb.append(this.delimiter);
                }
                String className = ste.getClassName();
                if (this.printBriefPackages) {
                    int dot;
                    int afterPrevDot = 0;
                    while ((dot = className.indexOf(46, afterPrevDot)) >= 0) {
                        sb.append(className.charAt(afterPrevDot));
                        sb.append('.');
                        afterPrevDot = dot + 1;
                    }
                    sb.append(className, afterPrevDot, className.length());
                } else {
                    sb.append(className);
                }
                sb.append('.');
                sb.append(ste.getMethodName());
                sb.append(':');
                sb.append(ste.getLineNumber());
            };
        }

        @Override
        public BinaryOperator<StringBuilder> combiner() {
            return (sb1, sb2) -> sb1.append("; ").append((CharSequence)sb2);
        }

        @Override
        public Function<StringBuilder, String> finisher() {
            return this;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }

        @Override
        public StringBuilder get() {
            return new StringBuilder(this.prefix);
        }

        @Override
        public String apply(StringBuilder finish) {
            finish.append(this.suffix);
            return finish.toString();
        }
    }
}

