/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.InfiniteLoopExecutor;
import org.apache.cassandra.concurrent.Interruptible;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.MemtableCleaner;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemtableCleanerThread<P extends MemtablePool>
implements Interruptible {
    private static final Logger logger = LoggerFactory.getLogger(MemtableCleanerThread.class);
    private final Interruptible executor;
    private final Runnable trigger;
    private final Clean<P> clean;

    private MemtableCleanerThread(Clean<P> clean) {
        this.executor = ExecutorFactory.Global.executorFactory().infiniteLoop(clean.pool.getClass().getSimpleName() + "Cleaner", clean, InfiniteLoopExecutor.SimulatorSafe.SAFE);
        this.trigger = clean.wait::signal;
        this.clean = clean;
    }

    public MemtableCleanerThread(P pool, MemtableCleaner cleaner) {
        this(new Clean<P>(pool, cleaner));
    }

    public void trigger() {
        this.trigger.run();
    }

    @VisibleForTesting
    public int numPendingTasks() {
        return this.clean.numPendingTasks();
    }

    @Override
    public void interrupt() {
        this.executor.interrupt();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public Object shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit units) throws InterruptedException {
        return this.executor.awaitTermination(timeout, units);
    }

    private static class Clean<P extends MemtablePool>
    implements Interruptible.SimpleTask {
        final AtomicInteger numPendingTasks = new AtomicInteger(0);
        final P pool;
        final MemtableCleaner cleaner;
        final WaitQueue wait = WaitQueue.newWaitQueue();

        private Clean(P pool, MemtableCleaner cleaner) {
            this.pool = pool;
            this.cleaner = cleaner;
        }

        public int numPendingTasks() {
            return this.numPendingTasks.get();
        }

        @Override
        public void run() throws InterruptedException {
            if (!((MemtablePool)this.pool).needsCleaning()) {
                WaitQueue.Signal signal = this.wait.register();
                if (!((MemtablePool)this.pool).needsCleaning()) {
                    signal.await();
                } else {
                    signal.cancel();
                }
            } else {
                int numPendingTasks = this.numPendingTasks.incrementAndGet();
                if (logger.isTraceEnabled()) {
                    logger.trace("Invoking cleaner with {} tasks pending", (Object)numPendingTasks);
                }
                this.cleaner.clean().addCallback(this::apply);
            }
        }

        private Boolean apply(Boolean res, Throwable err) {
            int tasks = this.numPendingTasks.decrementAndGet();
            if ((res.booleanValue() || err != null) && ((MemtablePool)this.pool).needsCleaning()) {
                this.wait.signal();
            }
            if (err != null) {
                logger.error("Memtable cleaning tasks failed with an exception and {} pending tasks ", (Object)tasks, (Object)err);
            } else if (logger.isTraceEnabled()) {
                logger.trace("Memtable cleaning task completed ({}), currently pending: {}", (Object)res, (Object)tasks);
            }
            return res;
        }

        public String toString() {
            return this.pool.toString() + " " + this.cleaner.toString();
        }
    }
}

