/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.List;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class ProcModuleInfo
extends SigarCommandBase {
    public ProcModuleInfo(Shell shell) {
        super(shell);
    }

    public ProcModuleInfo() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Display process module info";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        long[] pids = this.shell.findPids(args);
        for (int i = 0; i < pids.length; ++i) {
            try {
                this.output(pids[i]);
            }
            catch (SigarException e) {
                this.println("(" + e.getMessage() + ")");
            }
            this.println("\n------------------------\n");
        }
    }

    public void output(long pid) throws SigarException {
        this.println("pid=" + pid);
        try {
            List modules = this.sigar.getProcModules(pid);
            for (int i = 0; i < modules.size(); ++i) {
                this.println(i + "=" + modules.get(i));
            }
        }
        catch (SigarNotImplementedException e) {
            throw e;
        }
        catch (SigarException e) {
            this.println("[" + e.getMessage() + "]");
        }
    }

    public static void main(String[] args) throws Exception {
        new ProcModuleInfo().processCommand(args);
    }
}

