/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.extractor;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThreadConfinementAsserter;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.internal.extractor.DocumentExtractorUtil;
import org.jetbrains.annotations.NotNull;

public final class DocumentExtractorBuilder<E>
implements DocumentExtractor.Builder<E> {
    private final Class<E> elementType;
    private Supplier<? extends E> supplier;
    private boolean threadConfinedReuse;
    private MethodRef<Object, E> methodRef;

    public DocumentExtractorBuilder(@NotNull Class<E> elementType) {
        this.elementType = (Class)ObjectUtils.requireNonNull(elementType);
    }

    @Override
    @NotNull
    public DocumentExtractor.Builder<E> withReusing(@NotNull Supplier<? extends E> supplier) {
        this.supplier = (Supplier)ObjectUtils.requireNonNull(supplier);
        return this;
    }

    @Override
    @NotNull
    public DocumentExtractor.Builder<E> withThreadConfinedReuse() {
        this.threadConfinedReuse = true;
        return this;
    }

    @Override
    @NotNull
    public <I> DocumentExtractor.Builder<E> withMethod(@NotNull Class<I> interfaceType, @NotNull BiConsumer<? super I, ? super E> methodReference) {
        this.methodRef = new MethodRef<I, E>(interfaceType, methodReference);
        return this;
    }

    @NotNull
    public DocumentExtractor<E> build() {
        if (this.methodRef != null) {
            if (this.supplier == null) {
                return DocumentExtractorUtil.ofMethod(this.methodRef.interfaceType(), this.methodRef.methodReference(), () -> null);
            }
            return DocumentExtractorUtil.ofMethod(this.methodRef.interfaceType(), this.methodRef.methodReference(), this.guardedSupplier());
        }
        if (this.supplier == null) {
            return (wire, index) -> wire.getValueIn().object(this.elementType);
        }
        Supplier<E> internalSupplier = this.guardedSupplier();
        return (wire, index) -> {
            Object using = internalSupplier.get();
            return wire.getValueIn().object(using, this.elementType);
        };
    }

    Supplier<E> guardedSupplier() {
        return this.threadConfinedReuse ? new ThreadConfinedSupplier<E>(this.supplier) : new ThreadLocalSupplier<E>(this.supplier);
    }

    private static final class MethodRef<I, E> {
        final Class<I> interfaceType;
        final BiConsumer<I, E> methodReference;

        public MethodRef(@NotNull Class<I> interfaceType, @NotNull BiConsumer<? super I, ? super E> methodReference) {
            this.interfaceType = interfaceType;
            this.methodReference = methodReference;
        }

        public Class<I> interfaceType() {
            return this.interfaceType;
        }

        public BiConsumer<I, E> methodReference() {
            return this.methodReference;
        }
    }

    static final class ThreadConfinedSupplier<E>
    implements Supplier<E> {
        private final ThreadConfinementAsserter asserter = ThreadConfinementAsserter.createEnabled();
        private final E delegate;

        public ThreadConfinedSupplier(@NotNull Supplier<? extends E> supplier) {
            this.delegate = ObjectUtils.requireNonNull(supplier.get());
        }

        @Override
        public E get() {
            this.asserter.assertThreadConfined();
            return this.delegate;
        }
    }

    static final class ThreadLocalSupplier<E>
    implements Supplier<E> {
        private final ThreadLocal<E> threadLocal;

        public ThreadLocalSupplier(@NotNull Supplier<? extends E> supplier) {
            this.threadLocal = ThreadLocal.withInitial(supplier);
        }

        @Override
        public E get() {
            return this.threadLocal.get();
        }
    }
}

