/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public abstract class AbstractCloseable
implements ReferenceOwner,
ManagedCloseable,
SingleThreadedChecked {
    @Deprecated
    protected static final boolean DISABLE_THREAD_SAFETY = DISABLE_SINGLE_THREADED_CHECK;
    protected static final boolean DISABLE_DISCARD_WARNING = Jvm.getBoolean("disable.discard.warning", false);
    @Deprecated
    protected static final boolean STRICT_DISCARD_WARNING;
    protected static final long WARN_NS;
    private static final long CLOSED_OFFSET;
    private static final int STATE_NOT_CLOSED = 0;
    private static final int STATE_CLOSING = -1;
    private static final int STATE_CLOSED = 1;
    static volatile Set<Closeable> closeableSet;
    private final transient StackTrace createdHere;
    protected volatile transient StackTrace closedHere;
    private volatile transient int closed = 0;
    private volatile transient Thread usedByThread;
    private volatile transient StackTrace usedByThreadHere;
    private transient boolean singleThreadedCheckDisabled;
    @UsedViaReflection
    private transient Finalizer finalizer = DISABLE_DISCARD_WARNING ? null : new Finalizer();
    private int referenceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractCloseable() {
        this.createdHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " created here") : null;
        Set<Closeable> set = closeableSet;
        if (set != null) {
            Set<Closeable> set2 = set;
            synchronized (set2) {
                set.add(this);
            }
        }
    }

    public static void enableCloseableTracing() {
        closeableSet = Collections.newSetFromMap(new WeakIdentityHashMap());
    }

    public static void disableCloseableTracing() {
        closeableSet = null;
    }

    public static void gcAndWaitForCloseablesToClose() {
        CleaningThread.performCleanup(Thread.currentThread());
        final LinkedBlockingQueue q = new LinkedBlockingQueue();
        new Object(){

            protected void finalize() throws Throwable {
                super.finalize();
                q.add("finalized");
            }
        };
        System.gc();
        AbstractCloseable.waitForCloseablesToClose(1000L);
        try {
            if (q.poll(5L, TimeUnit.SECONDS) == null) {
                throw new AssertionError((Object)"Timed out waiting for the Finalizer");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForCloseablesToClose(long millis) {
        Set<Closeable> traceSet = closeableSet;
        if (traceSet == null) {
            return true;
        }
        if (Thread.interrupted()) {
            System.err.println("Interrupted in waitForCloseablesToClose!");
        }
        long end = System.currentTimeMillis() + millis;
        BackgroundResourceReleaser.releasePendingResources();
        block5: do {
            CleaningThreadLocal.cleanupNonCleaningThreads();
            Set<Closeable> set = traceSet;
            synchronized (set) {
                for (Closeable key : traceSet) {
                    try {
                        if (key instanceof AbstractCloseable) {
                            ((AbstractCloseable)key).singleThreadedCheckDisabled(true);
                        }
                        if (!(key instanceof ReferenceCountedTracer)) continue;
                        ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                    }
                    catch (IllegalStateException e) {
                        Jvm.pause(1L);
                        continue block5;
                    }
                }
            }
            Jvm.pause(1L);
            return true;
        } while (System.currentTimeMillis() < end);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCloseablesClosed() {
        Set<Closeable> traceSet = closeableSet;
        if (traceSet == null) {
            Jvm.warn().on(AbstractCloseable.class, "closable tracing disabled");
            return;
        }
        if (Thread.interrupted()) {
            System.err.println("Interrupted in assertCloseablesClosed!");
        }
        BackgroundResourceReleaser.releasePendingResources();
        AssertionError openFiles = new AssertionError((Object)"Closeables still open");
        Set<Closeable> set = traceSet;
        synchronized (set) {
            traceSet.removeIf(o -> o == null || o.isClosing());
            Set<Closeable> nested = Collections.newSetFromMap(new IdentityHashMap());
            for (Closeable key : traceSet) {
                AbstractCloseable.addNested(nested, key, 1);
            }
            Set<Closeable> traceSet2 = Collections.newSetFromMap(new IdentityHashMap());
            traceSet2.addAll(traceSet);
            traceSet2.removeAll(nested);
            for (int i = 0; i < 250; ++i) {
                if (traceSet2.stream().allMatch(QueryCloseable::isClosing)) {
                    return;
                }
                Jvm.pause(1L);
            }
            for (Closeable key : traceSet2) {
                Throwable t = null;
                try {
                    if (key instanceof ReferenceCountedTracer) {
                        ((ReferenceCountedTracer)((Object)key)).throwExceptionIfNotReleased();
                    }
                    if (key instanceof ManagedCloseable) {
                        t = ((ManagedCloseable)key).createdHere();
                    }
                }
                catch (IllegalStateException e) {
                    t = e;
                }
                IllegalStateException exception = new IllegalStateException("Not closed " + TracingReferenceCounted.asString(key), t);
                if (key.isClosed()) continue;
                exception.printStackTrace();
                ((Throwable)((Object)openFiles)).addSuppressed(exception);
                key.close();
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    private static void addNested(Set<Closeable> nested, Closeable key, int depth) {
        if (key.isClosing()) {
            return;
        }
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> keyClass = key.getClass();
        AbstractCloseable.getCloseableFields(keyClass, fields);
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Closeable o = (Closeable)field.get(key);
                if (o == null || !nested.add(o) || depth <= 1) continue;
                AbstractCloseable.addNested(nested, o, depth - 1);
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(keyClass, e);
            }
        }
    }

    private static void getCloseableFields(Class<?> keyClass, Set<Field> fields) {
        if (keyClass == null || keyClass == Object.class) {
            return;
        }
        for (Field field : keyClass.getDeclaredFields()) {
            if (!Closeable.class.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        AbstractCloseable.getCloseableFields(keyClass.getSuperclass(), fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmonitor(Closeable closeable) {
        Set<Closeable> set = closeableSet;
        if (set != null) {
            Set<Closeable> set2 = set;
            synchronized (set2) {
                set.remove(closeable);
            }
        }
    }

    @Override
    public int referenceId() {
        if (this.referenceId == 0) {
            this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        }
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public final void close() {
        this.assertCloseable();
        if (!UnsafeMemory.INSTANCE.compareAndSwapInt(this, CLOSED_OFFSET, 0, -1)) {
            if (this.shouldWaitForClosed() && this.isInUserThread()) {
                this.waitForClosed();
            }
            return;
        }
        StackTrace stackTrace = this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " closed here") : null;
        if (BackgroundResourceReleaser.BG_RELEASER && this.shouldPerformCloseInBackground()) {
            BackgroundResourceReleaser.release(this);
            return;
        }
        long start = System.nanoTime();
        this.callPerformClose();
        long time = System.nanoTime() - start;
        if (time >= WARN_NS && !BackgroundResourceReleaser.isOnBackgroundResourceReleaserThread()) {
            Jvm.perf().on(this.getClass(), "Took " + time / 1000000L + " ms to performClose");
        }
    }

    protected void assertCloseable() {
    }

    protected boolean isInUserThread() {
        return Thread.currentThread().getName().indexOf(126) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForClosed() {
        boolean interrupted = false;
        try {
            long start = System.currentTimeMillis();
            while (this.closed != 1) {
                if (System.currentTimeMillis() > start + 2500L) {
                    Jvm.warn().on(this.getClass(), "Aborting close()ing object " + this.referenceId + " after " + (double)(System.currentTimeMillis() - start) / 1000.0 + " secs", new StackTrace("waiting here", this.closedHere));
                    break;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosed()) {
            this.throwClosed();
        }
        this.threadSafetyCheck(true);
    }

    private void throwClosed() {
        throw new ClosedIllegalStateException(this.getClass().getName() + " closed for " + Thread.currentThread().getName(), this.closedHere);
    }

    public void throwExceptionIfClosedInSetter() throws IllegalStateException {
        if (this.isClosed()) {
            this.throwClosed();
        }
        this.threadSafetyCheck(false);
    }

    @Override
    public void warnAndCloseIfNotClosed() {
        if (!this.isClosing()) {
            if (Jvm.isResourceTracing() && !DISABLE_DISCARD_WARNING) {
                ExceptionHandler warn = Jvm.getBoolean("warnAndCloseIfNotClosed") ? Jvm.warn() : Slf4jExceptionHandler.WARN;
                warn.on(this.getClass(), "Discarded without closing", new IllegalStateException(this.createdHere));
            }
            this.close();
        }
    }

    protected abstract void performClose() throws IllegalStateException;

    void callPerformClose() {
        try {
            this.performClose();
        }
        catch (Throwable t) {
            Jvm.debug().on(this.getClass(), t);
        }
        finally {
            this.closed = 1;
        }
    }

    @Override
    public boolean isClosing() {
        return this.closed != 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed == 1;
    }

    protected boolean shouldPerformCloseInBackground() {
        return false;
    }

    protected boolean shouldWaitForClosed() {
        return false;
    }

    protected void threadSafetyCheck(boolean isUsed) throws IllegalStateException {
        if (DISABLE_SINGLE_THREADED_CHECK || this.singleThreadedCheckDisabled) {
            return;
        }
        this.threadSafetyCheck0(isUsed);
    }

    private void threadSafetyCheck0(boolean isUsed) {
        if (this.usedByThread == null && !isUsed) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == null) {
            this.usedByThread = currentThread;
            if (Jvm.isResourceTracing()) {
                this.usedByThreadHere = new StackTrace(this.getClass().getName() + " used here");
            }
        } else if (this.usedByThread != currentThread) {
            if (this.usedByThread.isAlive()) {
                throw new IllegalStateException(this.getClass().getName() + " component which is not thread safe used by " + this.usedByThread + " and " + currentThread, this.usedByThreadHere);
            }
            this.usedByThread = currentThread;
        }
    }

    @Deprecated
    public void resetUsedByThread() {
        this.singleThreadedCheckReset();
    }

    @Deprecated
    public void clearUsedByThread() {
        this.singleThreadedCheckReset();
    }

    @Override
    public void singleThreadedCheckReset() {
        this.usedByThread = null;
        this.usedByThreadHere = null;
    }

    public String toString() {
        return this.referenceName();
    }

    @Deprecated
    public boolean disableThreadSafetyCheck() {
        return this.singleThreadedCheckDisabled;
    }

    protected boolean singleThreadedCheckDisabled() {
        return this.singleThreadedCheckDisabled;
    }

    @Deprecated
    public AbstractCloseable disableThreadSafetyCheck(boolean disableThreadSafetyCheck) {
        this.singleThreadedCheckDisabled(disableThreadSafetyCheck);
        return this;
    }

    @Override
    public void singleThreadedCheckDisabled(boolean singleThreadedCheckDisabled) {
        this.singleThreadedCheckDisabled = singleThreadedCheckDisabled;
        if (singleThreadedCheckDisabled) {
            this.singleThreadedCheckReset();
        }
    }

    static {
        WARN_NS = (long)(Jvm.getDouble("closeable.warn.secs", 0.02) * 1.0E9);
        if (Jvm.isResourceTracing()) {
            AbstractCloseable.enableCloseableTracing();
        }
        CLOSED_OFFSET = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(AbstractCloseable.class, "closed"));
        if (Jvm.getProperty("strict.discard.warning") != null) {
            Jvm.warn().on(AbstractCloseable.class, "strict.discard.warning is deprecated and has no effect, it will be removed in x.25");
        }
        STRICT_DISCARD_WARNING = Jvm.getBoolean("strict.discard.warning", false);
    }

    class Finalizer {
        Finalizer() {
        }

        protected void finalize() throws Throwable {
            AbstractCloseable.this.warnAndCloseIfNotClosed();
            super.finalize();
        }
    }
}

