/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.jetbrains.annotations.Nullable;

class ReferenceChangeListenerManager {
    private final List<ReferenceChangeListener> referenceChangeListeners;
    private final ReferenceCounted owner;

    public ReferenceChangeListenerManager(ReferenceCounted owner) {
        this.owner = owner;
        this.referenceChangeListeners = new CopyOnWriteArrayList<ReferenceChangeListener>();
    }

    void add(ReferenceChangeListener referenceChangeListener) {
        this.referenceChangeListeners.add(referenceChangeListener);
    }

    void remove(ReferenceChangeListener referenceChangeListener) {
        this.referenceChangeListeners.remove(referenceChangeListener);
    }

    void notifyAdded(ReferenceOwner referenceOwner) {
        this.callReferenceChangeListeners((listener, referenceCounted, lhs, rhs) -> listener.onReferenceAdded(referenceCounted, lhs), referenceOwner, null);
    }

    void notifyRemoved(@Nullable ReferenceOwner referenceOwner) {
        this.callReferenceChangeListeners((listener, referenceCounted, lhs, rhs) -> listener.onReferenceRemoved(referenceCounted, lhs), referenceOwner, null);
    }

    void notifyTransferred(ReferenceOwner from, ReferenceOwner to) {
        this.callReferenceChangeListeners(ReferenceChangeListener::onReferenceTransferred, from, to);
    }

    private void callReferenceChangeListeners(ListenerInvoker listenerInvoker, ReferenceOwner lhs, ReferenceOwner rhs) {
        for (int i = 0; i < this.referenceChangeListeners.size(); ++i) {
            ReferenceChangeListener listener;
            try {
                listener = this.referenceChangeListeners.get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                continue;
            }
            listenerInvoker.invokeListener(listener, this.owner, lhs, rhs);
        }
    }

    public void clear() {
        this.referenceChangeListeners.clear();
    }

    private static interface ListenerInvoker {
        public void invokeListener(ReferenceChangeListener var1, ReferenceCounted var2, ReferenceOwner var3, ReferenceOwner var4);
    }
}

