/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.TimeProvider;

public enum SystemTimeProvider implements TimeProvider
{
    INSTANCE;

    private static final int NANOS_PER_MILLI = 1000000;
    public static TimeProvider CLOCK;
    private long delta = 0L;

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        return this.currentTimeNanos() / 1000L;
    }

    @Override
    public long currentTimeNanos() {
        long nowMS;
        long nowNS = System.nanoTime();
        long estimate = nowNS + this.delta;
        if (estimate < (nowMS = this.currentTimeMillis() * 1000000L)) {
            this.delta = nowMS - nowNS;
            return nowMS;
        }
        if (estimate > nowMS + 1000000L) {
            this.delta = (nowMS += 1000000L) - nowNS;
            return nowMS;
        }
        return estimate;
    }

    static {
        CLOCK = INSTANCE;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + 5L) {
            INSTANCE.currentTimeNanos();
            Jvm.nanoPause();
        }
    }
}

