/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.net.InetAddress;
import java.util.Set;
import org.apache.cassandra.auth.CIDRGroupsMappingManager;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.metrics.CIDRAuthorizerMetrics;

public interface ICIDRAuthorizer {
    public void setup();

    public void initCaches();

    public CIDRGroupsMappingManager getCidrGroupsMappingManager();

    public CIDRAuthorizerMetrics getCidrAuthorizerMetrics();

    public boolean requireAuthorization();

    public void setCidrGroupsForRole(RoleResource var1, CIDRPermissions var2);

    public void dropCidrPermissionsForRole(RoleResource var1);

    public boolean invalidateCidrPermissionsCache(String var1);

    public void validateConfiguration() throws ConfigurationException;

    public void loadCidrGroupsCache();

    public Set<String> lookupCidrGroupsForIp(InetAddress var1);

    public boolean hasAccessFromIp(RoleResource var1, InetAddress var2);

    public static enum CIDRAuthorizerMode {
        MONITOR,
        ENFORCE;

    }
}

