/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.compaction.TimeWindowCompactionStrategy;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.SchemaTransformation;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class AlterSchemaStatement
implements CQLStatement.SingleKeyspaceCqlStatement,
SchemaTransformation {
    protected final String keyspaceName;
    protected ClientState state;

    protected AlterSchemaStatement(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    @Override
    public void validate(ClientState state) {
        this.state = state;
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options, Dispatcher.RequestTime requestTime) {
        return this.execute(state, false);
    }

    @Override
    public String keyspace() {
        return this.keyspaceName;
    }

    @Override
    public ResultMessage executeLocally(QueryState state, QueryOptions options) {
        return this.execute(state, true);
    }

    abstract Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff var1);

    Set<IResource> createdResources(Keyspaces.KeyspacesDiff diff) {
        return ImmutableSet.of();
    }

    Set<String> clientWarnings(Keyspaces.KeyspacesDiff diff) {
        return ImmutableSet.of();
    }

    public ResultMessage execute(QueryState state, boolean locally) {
        if (SchemaConstants.isLocalSystemKeyspace(this.keyspaceName)) {
            throw AlterSchemaStatement.ire("System keyspace '%s' is not user-modifiable", this.keyspaceName);
        }
        KeyspaceMetadata keyspace = Schema.instance.getKeyspaceMetadata(this.keyspaceName);
        if (null != keyspace && keyspace.isVirtual()) {
            throw AlterSchemaStatement.ire("Virtual keyspace '%s' is not user-modifiable", this.keyspaceName);
        }
        KeyspaceMetadata.validateKeyspaceName(this.keyspaceName, x$0 -> AlterSchemaStatement.ire(x$0, new Object[0]));
        SchemaTransformation.SchemaTransformationResult result = Schema.instance.transform(this, locally);
        this.clientWarnings(result.diff).forEach(ClientWarn.instance::warn);
        if (result.diff.isEmpty()) {
            return new ResultMessage.Void();
        }
        AuthenticatedUser user = state.getClientState().getUser();
        if (null != user && !user.isAnonymous()) {
            this.createdResources(result.diff).forEach(r -> this.grantPermissionsOnResource((IResource)r, user));
        }
        return new ResultMessage.SchemaChange(this.schemaChangeEvent(result.diff));
    }

    protected void validateDefaultTimeToLive(TableParams params) {
        if (params.defaultTimeToLive == 0 && !SchemaConstants.isSystemKeyspace(this.keyspaceName) && TimeWindowCompactionStrategy.class.isAssignableFrom(params.compaction.klass())) {
            Guardrails.zeroTTLOnTWCSEnabled.ensureEnabled(this.state);
        }
    }

    private void grantPermissionsOnResource(IResource resource, AuthenticatedUser user) {
        try {
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, resource.applicablePermissions(), resource, user.getPrimaryRole());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    static InvalidRequestException ire(String format, Object ... args) {
        return new InvalidRequestException(String.format(format, args));
    }
}

