/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.StorageMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OwnedRanges {
    private static final Logger logger = LoggerFactory.getLogger(OwnedRanges.class);
    private static final Comparator<Range<Token>> rangeComparator = (r1, r2) -> {
        int cmp = ((Token)r1.left).compareTo((Token)r2.left);
        return cmp == 0 ? ((Token)r1.right).compareTo((Token)r2.right) : cmp;
    };
    private final List<Range<Token>> ownedRanges;

    public OwnedRanges(Collection<Range<Token>> ownedRanges) {
        this.ownedRanges = Range.normalize(ownedRanges);
    }

    public boolean validateRangeRequest(Collection<Range<Token>> requestedRanges, String requestId, String requestType, InetAddressAndPort from) {
        boolean outOfRangeTokenLogging = DatabaseDescriptor.getLogOutOfTokenRangeRequests();
        boolean outOfRangeTokenRejection = DatabaseDescriptor.getRejectOutOfTokenRangeRequests();
        Collection<Range<Token>> unownedRanges = this.testRanges(requestedRanges);
        if (!unownedRanges.isEmpty()) {
            StorageMetrics.totalOpsForInvalidToken.inc();
            if (outOfRangeTokenLogging) {
                logger.warn("[{}] Received {} from {} containing ranges {} outside valid ranges {}", new Object[]{requestId, requestType, from, unownedRanges, this.ownedRanges});
            }
        }
        return !outOfRangeTokenRejection || unownedRanges.isEmpty();
    }

    @VisibleForTesting
    Collection<Range<Token>> testRanges(Collection<Range<Token>> testedRanges) {
        if (this.ownedRanges.isEmpty()) {
            return testedRanges;
        }
        return Range.normalize(testedRanges).stream().filter(requested -> {
            int index = Collections.binarySearch(this.ownedRanges, requested, rangeComparator);
            if (index >= 0) {
                return false;
            }
            if ((index = Math.abs(index) - 1) >= this.ownedRanges.size()) {
                return !this.ownedRanges.get(index - 1).contains((Token)((Object)requested));
            }
            if (index == 0) {
                return !this.ownedRanges.get(index).contains((Token)((Object)requested));
            }
            return !this.ownedRanges.get(index - 1).contains((Token)((Object)requested)) && !this.ownedRanges.get(index).contains((Token)((Object)requested));
        }).collect(Collectors.toSet());
    }
}

