/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.memory.MemtableIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.view.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class QueryViewBuilder {
    private final Collection<Expression> expressions;
    private final AbstractBounds<PartitionPosition> range;

    QueryViewBuilder(Collection<Expression> expressions, AbstractBounds<PartitionPosition> range) {
        this.expressions = expressions;
        this.range = range;
    }

    protected QueryView build() {
        Collection<QueryExpressionView> view;
        HashSet<SSTableIndex> referencedIndexes = new HashSet<SSTableIndex>();
        while (true) {
            referencedIndexes.clear();
            boolean failed = false;
            view = this.getQueryView(this.expressions);
            for (SSTableIndex index : view.stream().map(v -> v.sstableIndexes).flatMap(Collection::stream).collect(Collectors.toList())) {
                if (index.reference()) {
                    referencedIndexes.add(index);
                    continue;
                }
                failed = true;
            }
            if (!failed) break;
            referencedIndexes.forEach(SSTableIndex::release);
        }
        return new QueryView(view, referencedIndexes);
    }

    private Collection<QueryExpressionView> getQueryView(Collection<Expression> expressions) {
        ArrayList<QueryExpressionView> queryView = new ArrayList<QueryExpressionView>();
        for (Expression expression : expressions) {
            if (expression.isNotIndexed()) continue;
            Collection<MemtableIndex> memtableIndexes = expression.getIndex().memtableIndexManager().getLiveMemtableIndexesSnapshot();
            View view = expression.getIndex().view();
            List<SSTableIndex> sstableIndexes = this.selectIndexesInRange(view.match(expression));
            queryView.add(new QueryExpressionView(expression, memtableIndexes, sstableIndexes));
        }
        return queryView;
    }

    private List<SSTableIndex> selectIndexesInRange(Collection<SSTableIndex> indexes) {
        return indexes.stream().filter(this::indexInRange).sorted(SSTableIndex.COMPARATOR).collect(Collectors.toList());
    }

    private boolean indexInRange(SSTableIndex index) {
        SSTableReader sstable = index.getSSTable();
        return ((PartitionPosition)this.range.left).compareTo(sstable.getLast()) <= 0 && (((PartitionPosition)this.range.right).isMinimum() || sstable.getFirst().compareTo((PartitionPosition)this.range.right) <= 0);
    }

    public static class QueryView {
        public final Collection<QueryExpressionView> view;
        public final Set<SSTableIndex> referencedIndexes;

        public QueryView(Collection<QueryExpressionView> view, Set<SSTableIndex> referencedIndexes) {
            this.view = view;
            this.referencedIndexes = referencedIndexes;
        }
    }

    public static class QueryExpressionView {
        public final Expression expression;
        public final Collection<MemtableIndex> memtableIndexes;
        public final Collection<SSTableIndex> sstableIndexes;

        public QueryExpressionView(Expression expression, Collection<MemtableIndex> memtableIndexes, Collection<SSTableIndex> sstableIndexes) {
            this.expression = expression;
            this.memtableIndexes = memtableIndexes;
            this.sstableIndexes = sstableIndexes;
        }
    }
}

