/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableScanner;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.PartitionIterator;
import org.apache.cassandra.io.sstable.format.bti.TrieIndexEntry;
import org.apache.cassandra.io.util.FileUtils;

public class BtiTableScanner
extends SSTableScanner<BtiTableReader, TrieIndexEntry, BtiScanningIterator> {
    public static BtiTableScanner getScanner(BtiTableReader sstable, ColumnFilter columns, DataRange dataRange, SSTableReadsListener listener) {
        return new BtiTableScanner(sstable, columns, dataRange, BtiTableScanner.makeBounds(sstable, dataRange).iterator(), listener);
    }

    private BtiTableScanner(BtiTableReader sstable, ColumnFilter columns, DataRange dataRange, Iterator<AbstractBounds<PartitionPosition>> rangeIterator, SSTableReadsListener listener) {
        super(sstable, columns, dataRange, rangeIterator, listener);
    }

    @Override
    protected void doClose() throws IOException {
        FileUtils.close(this.dfile, (Closeable)((Object)this.iterator));
    }

    @Override
    protected BtiScanningIterator doCreateIterator() {
        return new BtiScanningIterator();
    }

    protected class BtiScanningIterator
    extends SSTableScanner.BaseKeyScanningIterator
    implements Closeable {
        private PartitionIterator iterator;

        protected BtiScanningIterator() {
        }

        @Override
        protected boolean prepareToIterateRow() throws IOException {
            while (true) {
                if (BtiTableScanner.this.startScan != -1L) {
                    BtiTableScanner.this.bytesScanned += BtiTableScanner.this.getCurrentPosition() - BtiTableScanner.this.startScan;
                }
                if (this.iterator != null) {
                    this.currentEntry = this.iterator.entry();
                    this.currentKey = this.iterator.decoratedKey();
                    if (this.currentEntry != null) {
                        this.iterator.advance();
                        return true;
                    }
                    this.iterator.close();
                    this.iterator = null;
                }
                if (!BtiTableScanner.this.rangeIterator.hasNext()) {
                    return false;
                }
                this.iterator = ((BtiTableReader)BtiTableScanner.this.sstable).coveredKeysIterator((AbstractBounds)BtiTableScanner.this.rangeIterator.next());
            }
        }

        protected UnfilteredRowIterator getRowIterator(TrieIndexEntry indexEntry, DecoratedKey key) {
            if (BtiTableScanner.this.dataRange == null) {
                return ((BtiTableReader)BtiTableScanner.this.sstable).simpleIterator(BtiTableScanner.this.dfile, key, indexEntry.position, false);
            }
            ClusteringIndexFilter filter = BtiTableScanner.this.dataRange.clusteringIndexFilter(key);
            return ((BtiTableReader)BtiTableScanner.this.sstable).rowIterator(BtiTableScanner.this.dfile, key, indexEntry, filter.getSlices(BtiTableScanner.this.metadata()), BtiTableScanner.this.columns, filter.isReversed());
        }

        @Override
        public void close() {
            super.close();
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
    }
}

