/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.ReadableMemory;
import org.apache.cassandra.io.util.SafeMemory;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.memory.LittleEndianMemoryUtil;
import org.apache.cassandra.utils.memory.MemoryUtil;
import sun.misc.Unsafe;

public class Memory
implements AutoCloseable,
ReadableMemory {
    private static final Unsafe unsafe;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    public static final ByteBuffer[] NO_BYTE_BUFFERS;
    protected long peer;
    protected final long size;

    protected Memory(long bytes) {
        if (bytes <= 0L) {
            throw new AssertionError();
        }
        this.size = bytes;
        this.peer = MemoryUtil.allocate(this.size);
        if (this.peer == 0L) {
            throw new OutOfMemoryError();
        }
    }

    protected Memory(Memory copyOf) {
        this.size = copyOf.size;
        this.peer = copyOf.peer;
    }

    public static Memory allocate(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException();
        }
        if (Ref.DEBUG_ENABLED) {
            return new SafeMemory(bytes);
        }
        return new Memory(bytes);
    }

    public void setByte(long offset, byte b) {
        this.checkBounds(offset, offset + 1L);
        LittleEndianMemoryUtil.setByte(this.peer + offset, b);
    }

    public void setMemory(long offset, long bytes, byte b) {
        this.checkBounds(offset, offset + bytes);
        unsafe.setMemory(this.peer + offset, bytes, b);
    }

    public void setLong(long offset, long l) {
        this.checkBounds(offset, offset + 8L);
        LittleEndianMemoryUtil.setLong(this.peer + offset, l);
    }

    public void setInt(long offset, int l) {
        this.checkBounds(offset, offset + 4L);
        LittleEndianMemoryUtil.setInt(this.peer + offset, l);
    }

    public void setBytes(long memoryOffset, ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.remaining() == 0) {
            return;
        }
        this.checkBounds(memoryOffset, memoryOffset + (long)buffer.remaining());
        if (buffer.hasArray()) {
            this.setBytes(memoryOffset, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else if (buffer.isDirect()) {
            unsafe.copyMemory(MemoryUtil.getAddress(buffer) + (long)buffer.position(), this.peer + memoryOffset, buffer.remaining());
        } else {
            throw new IllegalStateException();
        }
    }

    public void setBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || bufferOffset + count > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkBounds(memoryOffset, memoryOffset + (long)count);
        unsafe.copyMemory(buffer, BYTE_ARRAY_BASE_OFFSET + (long)bufferOffset, null, this.peer + memoryOffset, count);
    }

    public byte getByte(long offset) {
        this.checkBounds(offset, offset + 1L);
        return LittleEndianMemoryUtil.getByte(this.peer + offset);
    }

    public long getLong(long offset) {
        this.checkBounds(offset, offset + 8L);
        return LittleEndianMemoryUtil.getLong(this.peer + offset);
    }

    public int getInt(long offset) {
        this.checkBounds(offset, offset + 4L);
        return LittleEndianMemoryUtil.getInt(this.peer + offset);
    }

    public void getBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkBounds(memoryOffset, memoryOffset + (long)count);
        FastByteOperations.UnsafeOperations.copy(null, this.peer + memoryOffset, buffer, bufferOffset, count);
    }

    protected void checkBounds(long start, long end) {
        assert (this.peer != 0L) : "Memory was freed";
        assert (start >= 0L && end <= this.size && start <= end) : "Illegal bounds [" + start + ".." + end + "); size: " + this.size;
    }

    public void put(long trgOffset, Memory memory, long srcOffset, long size) {
        this.checkBounds(trgOffset, trgOffset + size);
        memory.checkBounds(srcOffset, srcOffset + size);
        unsafe.copyMemory(memory.peer + srcOffset, this.peer + trgOffset, size);
    }

    public Memory copy(long newSize) {
        Memory copy = Memory.allocate(newSize);
        copy.put(0L, this, 0L, Math.min(this.size(), newSize));
        return copy;
    }

    public void free() {
        if (this.peer != 0L) {
            MemoryUtil.free(this.peer);
        } else assert (this.size == 0L);
        this.peer = 0L;
    }

    @Override
    public void close() {
        this.free();
    }

    public long size() {
        assert (this.peer != 0L);
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Memory)) {
            return false;
        }
        Memory b = (Memory)o;
        return this.peer == b.peer && this.size == b.size;
    }

    @Override
    public ByteBuffer[] asByteBuffers(long offset, long length) {
        this.checkBounds(offset, offset + length);
        if (this.size() == 0L) {
            return NO_BYTE_BUFFERS;
        }
        ByteBuffer[] result = new ByteBuffer[(int)(length / Integer.MAX_VALUE) + 1];
        int size = (int)(this.size() / (long)result.length);
        for (int i = 0; i < result.length - 1; ++i) {
            result[i] = LittleEndianMemoryUtil.getByteBuffer(this.peer + offset, size);
            offset += (long)size;
            length -= (long)size;
        }
        result[result.length - 1] = LittleEndianMemoryUtil.getByteBuffer(this.peer + offset, (int)length);
        return result;
    }

    public ByteBuffer asByteBuffer(long offset, int length) {
        this.checkBounds(offset, offset + (long)length);
        return LittleEndianMemoryUtil.getByteBuffer(this.peer + offset, length);
    }

    public void setByteBuffer(ByteBuffer buffer, long offset, int length) {
        this.checkBounds(offset, offset + (long)length);
        MemoryUtil.setDirectByteBuffer(buffer, this.peer + offset, length);
    }

    public String toString() {
        return Memory.toString(this.peer, this.size);
    }

    protected static String toString(long peer, long size) {
        return String.format("Memory@[%x..%x)", peer, peer + size);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        NO_BYTE_BUFFERS = new ByteBuffer[0];
    }
}

