/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.ShareableBytes;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class FrameDecoder
extends ChannelInboundHandlerAdapter {
    private static final FrameProcessor NO_PROCESSOR = frame -> {
        throw new IllegalStateException("Frame processor invoked on an unregistered FrameDecoder");
    };
    private static final FrameProcessor CLOSED_PROCESSOR = frame -> {
        throw new IllegalStateException("Frame processor invoked on a closed FrameDecoder");
    };
    protected final BufferPoolAllocator allocator;
    @VisibleForTesting
    final Deque<Frame> frames = new ArrayDeque<Frame>(4);
    ByteBuffer stash;
    private boolean isActive;
    private boolean isClosed;
    private ChannelHandlerContext ctx;
    private FrameProcessor processor = NO_PROCESSOR;

    FrameDecoder(BufferPoolAllocator allocator) {
        this.allocator = allocator;
    }

    abstract void decode(Collection<Frame> var1, ShareableBytes var2);

    abstract void addLastTo(ChannelPipeline var1);

    public boolean isActive() {
        return this.isActive;
    }

    public void activate(FrameProcessor processor) {
        if (this.processor != NO_PROCESSOR) {
            throw new IllegalStateException("Attempted to activate an already active FrameDecoder");
        }
        this.processor = processor;
        this.isActive = true;
        this.ctx.read();
    }

    public void reactivate() throws IOException {
        if (this.isActive) {
            throw new IllegalStateException("Tried to reactivate an already active FrameDecoder");
        }
        if (this.deliver(this.processor)) {
            this.isActive = true;
            this.onExhausted();
        }
    }

    void processBacklog(FrameProcessor processor) throws IOException {
        this.deliver(processor);
    }

    public void discard() {
        this.isActive = false;
        this.processor = CLOSED_PROCESSOR;
        if (this.stash != null) {
            ByteBuffer bytes = this.stash;
            this.stash = null;
            this.allocator.put(bytes);
        }
        while (!this.frames.isEmpty()) {
            this.frames.poll().release();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws IOException {
        if (!(msg instanceof BufferPoolAllocator.Wrapped)) {
            throw new IllegalArgumentException();
        }
        ByteBuffer buf = ((BufferPoolAllocator.Wrapped)((Object)msg)).adopt();
        this.allocator.putUnusedPortion(buf);
        this.channelRead(ShareableBytes.wrap(buf));
    }

    void channelRead(ShareableBytes bytes) throws IOException {
        this.decode(this.frames, bytes);
        if (this.isActive) {
            this.isActive = this.deliver(this.processor);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.isActive) {
            this.onExhausted();
        }
    }

    private void onExhausted() {
        if (this.isClosed) {
            this.close();
        } else {
            this.ctx.read();
        }
    }

    private boolean deliver(FrameProcessor processor) throws IOException {
        boolean deliver = true;
        while (deliver && !this.frames.isEmpty()) {
            Frame frame = this.frames.peek();
            deliver = processor.process(frame);
            assert (!deliver || frame.isConsumed());
            if (!deliver && !frame.isConsumed()) continue;
            this.frames.poll();
            frame.release();
        }
        return deliver;
    }

    void stash(ShareableBytes in, int stashLength, int begin, int length) {
        ByteBuffer out = this.allocator.getAtLeast(stashLength);
        ByteBufferUtil.copyBytes(in.get(), begin, out, 0, length);
        out.position(length);
        this.stash = out;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        ctx.channel().config().setAutoRead(false);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.isClosed = true;
        if (this.frames.isEmpty()) {
            this.close();
        }
    }

    private void close() {
        this.discard();
        this.ctx.fireChannelInactive();
        this.allocator.release();
    }

    static boolean copyToSize(ByteBuffer in, ByteBuffer out, int toOutPosition) {
        int bytesToSize = toOutPosition - out.position();
        if (bytesToSize <= 0) {
            return true;
        }
        if (bytesToSize > in.remaining()) {
            out.put(in);
            return false;
        }
        ByteBufferUtil.copyBytes(in, in.position(), out, out.position(), bytesToSize);
        in.position(in.position() + bytesToSize);
        out.position(toOutPosition);
        return true;
    }

    ByteBuffer ensureCapacity(ByteBuffer in, int capacity) {
        if (in.capacity() >= capacity) {
            return in;
        }
        ByteBuffer out = this.allocator.getAtLeast(capacity);
        in.flip();
        out.put(in);
        this.allocator.put(in);
        return out;
    }

    public static final class CorruptFrame
    extends Frame {
        public final int readCRC;
        public final int computedCRC;

        CorruptFrame(boolean isSelfContained, int frameSize, int readCRC, int computedCRC) {
            super(isSelfContained, frameSize);
            this.readCRC = readCRC;
            this.computedCRC = computedCRC;
        }

        static CorruptFrame recoverable(boolean isSelfContained, int frameSize, int readCRC, int computedCRC) {
            return new CorruptFrame(isSelfContained, frameSize, readCRC, computedCRC);
        }

        static CorruptFrame unrecoverable(int readCRC, int computedCRC) {
            return new CorruptFrame(false, Integer.MIN_VALUE, readCRC, computedCRC);
        }

        public boolean isRecoverable() {
            return this.frameSize != Integer.MIN_VALUE;
        }

        @Override
        void release() {
        }

        @Override
        boolean isConsumed() {
            return true;
        }
    }

    public static final class IntactFrame
    extends Frame {
        public final ShareableBytes contents;

        IntactFrame(boolean isSelfContained, ShareableBytes contents) {
            super(isSelfContained, contents.remaining());
            this.contents = contents;
        }

        @Override
        void release() {
            this.contents.release();
        }

        @Override
        boolean isConsumed() {
            return !this.contents.hasRemaining();
        }

        public void consume() {
            this.contents.consume();
        }
    }

    public static abstract class Frame {
        public final boolean isSelfContained;
        public final int frameSize;

        Frame(boolean isSelfContained, int frameSize) {
            this.isSelfContained = isSelfContained;
            this.frameSize = frameSize;
        }

        abstract void release();

        abstract boolean isConsumed();
    }

    public static interface FrameProcessor {
        public boolean process(Frame var1) throws IOException;
    }
}

