/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BytesSerializer
extends TypeSerializer<ByteBuffer> {
    public static final BytesSerializer instance = new BytesSerializer();

    @Override
    public ByteBuffer serialize(ByteBuffer bytes) {
        return bytes.duplicate();
    }

    @Override
    public <V> ByteBuffer deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.toBuffer(value);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
    }

    @Override
    public String toString(ByteBuffer value) {
        return ByteBufferUtil.bytesToHex(value);
    }

    @Override
    public Class<ByteBuffer> getType() {
        return ByteBuffer.class;
    }

    @Override
    public <V> boolean isNull(V buffer, ValueAccessor<V> accessor) {
        return buffer == null;
    }

    @Override
    protected String toCQLLiteralNonNull(ByteBuffer buffer) {
        return "0x" + this.toString((ByteBuffer)this.deserialize(buffer));
    }
}

