/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.utils.UUIDSerializer;

public class PaxosCleanupResponse {
    public final UUID session;
    public final boolean wasSuccessful;
    public final String message;
    public static final IVerbHandler<PaxosCleanupResponse> verbHandler = PaxosCleanupResponse.createVerbHandler(SharedContext.Global.instance);
    public static final IVersionedSerializer<PaxosCleanupResponse> serializer = new IVersionedSerializer<PaxosCleanupResponse>(){

        @Override
        public void serialize(PaxosCleanupResponse finished, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(finished.session, out, version);
            out.writeBoolean(finished.wasSuccessful);
            out.writeBoolean(finished.message != null);
            if (finished.message != null) {
                out.writeUTF(finished.message);
            }
        }

        @Override
        public PaxosCleanupResponse deserialize(DataInputPlus in, int version) throws IOException {
            UUID session = UUIDSerializer.serializer.deserialize(in, version);
            boolean success = in.readBoolean();
            String message = in.readBoolean() ? in.readUTF() : null;
            return new PaxosCleanupResponse(session, success, message);
        }

        @Override
        public long serializedSize(PaxosCleanupResponse finished, int version) {
            long size = UUIDSerializer.serializer.serializedSize(finished.session, version);
            size += (long)TypeSizes.sizeof(finished.wasSuccessful);
            size += (long)TypeSizes.sizeof(finished.message != null);
            if (finished.message != null) {
                size += (long)TypeSizes.sizeof(finished.message);
            }
            return size;
        }
    };

    public PaxosCleanupResponse(UUID session, boolean wasSuccessful, @Nullable String message) {
        this.session = session;
        this.wasSuccessful = wasSuccessful;
        this.message = message;
    }

    public static PaxosCleanupResponse success(UUID session) {
        return new PaxosCleanupResponse(session, true, null);
    }

    public static PaxosCleanupResponse failed(UUID session, String message) {
        return new PaxosCleanupResponse(session, false, message);
    }

    public static IVerbHandler<PaxosCleanupResponse> createVerbHandler(SharedContext ctx) {
        return message -> ctx.paxosRepairState().finishSession(message.from(), (PaxosCleanupResponse)message.payload);
    }
}

