/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getcidrgroupsofip", description="Print CIDR groups associated with given IP")
public class GetCIDRGroupsOfIP
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<IP address>", description="Requires IP address as a string")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        Preconditions.checkArgument((this.args.size() == 1 ? 1 : 0) != 0, (Object)"Requires IP address as input");
        String ipStr = this.args.get(0);
        probe.printSet(out, "CIDR Groups", probe.getCidrGroupsOfIp(ipStr));
    }
}

