/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.TimeZone;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cmd.AntPathMatcher;
import org.gridkit.jvmtool.event.ChainedEventReader;
import org.gridkit.jvmtool.event.ErrorHandler;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventDumpParser;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.ShieldedEventReader;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.event.SingleEventReader;
import org.gridkit.jvmtool.event.TimestampedEvent;
import org.gridkit.jvmtool.stacktrace.ThreadEventCodec;
import org.gridkit.jvmtool.stacktrace.analytics.TimeRangeChecker;

public abstract class AbstractEventDumpSource {
    protected CommandLauncher host;
    @Parameter(names={"-tr", "--time-range"}, required=false, description="Time range filter")
    protected String timeRange = null;
    @Parameter(names={"--parsers-info"}, required=false, description="Print parsers available in classpath")
    protected boolean reportParsers = false;
    private boolean wildcardFileMatching = true;
    protected TimeZone timeZone;
    private List<String> matchedInputFiles;

    public AbstractEventDumpSource(CommandLauncher host) {
        this.host = host;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    public void useWildcards(boolean enabled) {
        this.wildcardFileMatching = enabled;
    }

    protected abstract List<String> inputFiles();

    public List<String> sourceFiles() {
        if (this.matchedInputFiles == null) {
            this.matchedInputFiles = new ArrayList<String>();
            if (this.wildcardFileMatching) {
                List<String> rawInput = this.inputFiles();
                AntPathMatcher matcher = new AntPathMatcher();
                matcher.setPathSeparator("/");
                for (String f : rawInput) {
                    f = f.replace('\\', '/');
                    for (File ff : matcher.findFiles(new File("."), f)) {
                        if (!ff.isFile()) continue;
                        this.matchedInputFiles.add(ff.getPath());
                    }
                }
            } else {
                this.matchedInputFiles.addAll(this.inputFiles());
            }
            if (this.matchedInputFiles.isEmpty()) {
                this.host.fail(new String[]{"No input files provided"});
            }
        }
        return this.matchedInputFiles;
    }

    public EventReader<Event> getFilteredRawReader() {
        if (this.timeRange != null) {
            String[] lh = this.timeRange.split("[-]");
            if (lh.length != 2) {
                this.host.fail(new String[]{"Invalid time range '" + this.timeRange + "'", "Valid format yyyy.MM.dd_HH:mm:ss-yyyy.MM.dd_HH:mm:ss hours and higher parts can be ommited"});
            }
            TimeRangeChecker checker = new TimeRangeChecker(lh[0], lh[1], this.timeZone);
            return this.getRawReader().morph((EventMorpher)new TimeFilter(checker));
        }
        return this.getRawReader();
    }

    public EventReader<Event> getRawReader() {
        final Iterator<String> it = this.sourceFiles().iterator();
        ChainedEventReader<Event> reader = new ChainedEventReader<Event>(){

            protected EventReader<Event> produceNext() {
                return it.hasNext() ? AbstractEventDumpSource.this.openReader((String)it.next()) : null;
            }
        };
        ShieldedEventReader shieldedReader = new ShieldedEventReader((EventReader)reader, Event.class, new ErrorHandler(){

            public boolean onException(Exception e) {
                System.err.println("Stream reader error: " + e);
                e.printStackTrace();
                return true;
            }
        });
        return shieldedReader;
    }

    protected EventReader<Event> openReader(String file) {
        if (this.reportParsers) {
            this.printParsers();
        }
        try {
            return ThreadEventCodec.createEventReader((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            EventReader<Event> reader = this.openGenericDump(file);
            if (reader != null) {
                return reader;
            }
            return new SingleEventReader((Event)new SimpleErrorEvent((Exception)e));
        }
    }

    private void printParsers() {
        System.out.println("Available file parsers");
        for (String parser : ThreadEventCodec.listSupportedFormats()) {
            System.out.println(" - " + parser);
        }
        ServiceLoader<EventDumpParser> loader = ServiceLoader.load(EventDumpParser.class);
        for (EventDumpParser edp : loader) {
            System.out.println(" - " + edp);
        }
    }

    private String getParserString() {
        StringBuilder sb = new StringBuilder();
        for (String parser : ThreadEventCodec.listSupportedFormats()) {
            sb.append(parser).append(", ");
        }
        ServiceLoader<EventDumpParser> loader = ServiceLoader.load(EventDumpParser.class);
        for (EventDumpParser edp : loader) {
            if (!edp.isFunctional()) continue;
            sb.append(edp).append(", ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    protected EventReader<Event> openGenericDump(String file) {
        ServiceLoader<EventDumpParser> loader = ServiceLoader.load(EventDumpParser.class);
        FileSource fs = new FileSource(file);
        for (EventDumpParser edp : loader) {
            try {
                EventReader r = edp.open((EventDumpParser.InputStreamSource)fs);
                if (r == null) continue;
                return r;
            }
            catch (Exception e) {
            }
            catch (NoClassDefFoundError ee) {
                ee.printStackTrace();
            }
        }
        if (new File(file).isFile() && new File(file).length() > 0L) {
            this.host.logError("Unable to parse file '" + file + "'. Parser config: " + this.getParserString());
        }
        return null;
    }

    private static class FileSource
    implements EventDumpParser.InputStreamSource {
        final String file;
        InputStream is;

        public FileSource(String file) {
            this.file = file;
        }

        public InputStream open() throws IOException {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.is = new FileInputStream(this.file);
            return this.is;
        }
    }

    static class TimeFilter
    implements EventMorpher<Event, Event> {
        TimeRangeChecker checker;

        public TimeFilter(TimeRangeChecker checker) {
            this.checker = checker;
        }

        public Event morph(Event event) {
            if (event instanceof TimestampedEvent) {
                return this.checker.evaluate(((TimestampedEvent)event).timestamp()) ? event : null;
            }
            return null;
        }
    }
}

