/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

public final class IdentityHashSet {
    int size;
    Object[] table = new Object[32];

    boolean add(Object o) {
        while (true) {
            Object item;
            Object[] tab = this.table;
            int len = tab.length;
            int mask = len - 1;
            int i = IdentityHashSet.index(o, mask);
            while ((item = tab[i]) != null) {
                if (item == o) {
                    return false;
                }
                i = IdentityHashSet.inc(i, len);
            }
            int s = this.size + 1;
            if (s + (s << 1) <= len << 1) {
                this.size = s;
                tab[i] = o;
                return true;
            }
            this.resize();
        }
    }

    private void resize() {
        Object[] tab = this.table;
        int newLength = tab.length << 1;
        if (newLength < 0) {
            throw new IllegalStateException("too many objects visited");
        }
        Object[] n = new Object[newLength];
        int mask = newLength - 1;
        for (Object o : tab) {
            if (o == null) continue;
            int i = IdentityHashSet.index(o, mask);
            while (n[i] != null) {
                i = IdentityHashSet.inc(i, newLength);
            }
            n[i] = o;
        }
        this.table = n;
    }

    private static int index(Object o, int mask) {
        return System.identityHashCode(o) & mask;
    }

    private static int inc(int i, int len) {
        int n = i + 1;
        return n >= len ? 0 : n;
    }
}

