/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class Sets<T>
extends Generator<Set<T>> {
    final Generator<T> valueType;

    public Sets(String name, Generator<T> valueType, GeneratorConfig config) {
        super((AbstractType<?>)SetType.getInstance(valueType.type, (boolean)true), config, name, Set.class);
        this.valueType = valueType;
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.valueType.setSeed(seed * 31L);
    }

    @Override
    public Set<T> generate() {
        HashSet<T> set = new HashSet<T>();
        int size = (int)this.sizeDistribution.next();
        for (int i = 0; i < size; ++i) {
            set.add(this.valueType.generate());
        }
        return set;
    }
}

