/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.Utils;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Base64;

abstract class EvpSignatureBase
extends SignatureSpi {
    static final String P1363_FORMAT_SUFFIX = "inP1363Format";
    protected static final int RSA_PKCS1_PADDING = 1;
    protected static final int RSA_PKCS1_PSS_PADDING = 6;
    protected final AmazonCorrettoCryptoProvider provider_;
    protected final EvpKeyType keyType_;
    protected int paddingType_;
    protected Key untranslatedKey_ = null;
    protected EvpKey key_ = null;
    protected boolean signMode;
    protected int keyUsageCount_ = 0;
    protected String algorithmName_ = null;
    protected PSSParameterSpec pssParams_ = null;
    protected long digest_ = 0L;
    protected long pssMgfMd_ = 0L;
    protected int pssSaltLen_ = 0;

    EvpSignatureBase(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, EvpKeyType evpKeyType, int n, long l) {
        this.provider_ = amazonCorrettoCryptoProvider;
        this.keyType_ = evpKeyType;
        this.paddingType_ = n;
        if (this.paddingType_ == 6) {
            this.internalSetParams(PSSParameterSpec.DEFAULT);
        } else {
            this.internalSetParams(null);
            this.digest_ = l;
        }
    }

    protected void internalSetParams(PSSParameterSpec pSSParameterSpec) {
        if (pSSParameterSpec == null) {
            this.pssParams_ = null;
            this.digest_ = 0L;
            this.pssMgfMd_ = 0L;
            this.pssSaltLen_ = 0;
        } else {
            this.pssParams_ = pSSParameterSpec;
            this.digest_ = Utils.getMdPtr(pSSParameterSpec.getDigestAlgorithm());
            this.pssMgfMd_ = Utils.getMdPtr(((MGF1ParameterSpec)pSSParameterSpec.getMGFParameters()).getDigestAlgorithm());
            this.pssSaltLen_ = pSSParameterSpec.getSaltLength();
        }
    }

    protected abstract void engineReset();

    void setAlgorithmName(String string) {
        this.algorithmName_ = string;
    }

    private static native void destroyContext(long var0);

    @Override
    protected synchronized void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (this.untranslatedKey_ != privateKey) {
            if (!this.keyType_.jceName.equalsIgnoreCase(privateKey.getAlgorithm())) {
                throw new InvalidKeyException();
            }
            this.keyUsageCount_ = 0;
            this.untranslatedKey_ = privateKey;
            if (this.key_ != null) {
                this.key_.releaseEphemeral();
            }
            this.key_ = this.provider_.translateKey(this.untranslatedKey_, this.keyType_);
        }
        this.signMode = true;
        this.engineReset();
    }

    @Override
    protected synchronized void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (this.untranslatedKey_ != publicKey) {
            if (!this.keyType_.jceName.equalsIgnoreCase(publicKey.getAlgorithm())) {
                throw new InvalidKeyException();
            }
            this.keyUsageCount_ = 0;
            this.untranslatedKey_ = publicKey;
            if (this.key_ != null) {
                this.key_.releaseEphemeral();
            }
            this.key_ = this.provider_.translateKey(this.untranslatedKey_, this.keyType_);
        }
        this.signMode = false;
        this.engineReset();
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected synchronized void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            int n;
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            if (this.keyType_ != EvpKeyType.RSA || this.paddingType_ != 6) {
                throw new InvalidAlgorithmParameterException("PSS params only supported for RSASSA-PSS signatures");
            }
            if (!this.isBufferEmpty()) {
                throw new IllegalStateException("Cannot update PSS parameters with buffered data, reset Signature.");
            }
            if (!"MGF1".equals(pSSParameterSpec.getMGFAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Invalid PSS MGF algorithm");
            }
            if (pSSParameterSpec.getTrailerField() != PSSParameterSpec.DEFAULT.getTrailerField()) {
                throw new IllegalArgumentException("Invalid PSS trailer field");
            }
            if (pSSParameterSpec.getMGFParameters() == null) {
                throw new InvalidAlgorithmParameterException("PSS parameters must specify MGF1 parameters");
            }
            try {
                Utils.getMdPtr(pSSParameterSpec.getDigestAlgorithm());
                Utils.getMdPtr(((MGF1ParameterSpec)pSSParameterSpec.getMGFParameters()).getDigestAlgorithm());
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException();
            }
            int n2 = pSSParameterSpec.getSaltLength();
            int n3 = Utils.getMdLen(Utils.getMdPtr(pSSParameterSpec.getDigestAlgorithm()));
            int n4 = n = this.key_ != null ? (((RSAKey)((Object)this.key_)).getModulus().bitLength() + 7) / 8 : 256;
            if (n2 < 0 || n2 > n - n3 - 2) {
                throw new IllegalArgumentException("PSS salt length invalid");
            }
            this.internalSetParams(pSSParameterSpec);
        } else if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Specified parameters supported by this algorithm");
        }
    }

    protected abstract boolean isBufferEmpty();

    @Override
    protected synchronized AlgorithmParameters engineGetParameters() {
        if (this.paddingType_ == 6 && this.pssParams_ != null) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("RSASSA-PSS");
                algorithmParameters.init(this.pssParams_);
                return algorithmParameters;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new UnsupportedOperationException("RSASSA-PSS unsupported.", noSuchAlgorithmException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new AssertionError((Object)generalSecurityException);
            }
        }
        return null;
    }

    protected void ensureInitialized(Boolean bl) throws SignatureException {
        if (this.key_ == null) {
            throw new SignatureException("Not initialized");
        }
        if (bl != null && bl != this.signMode) {
            throw new SignatureException("Incorrect mode for operation");
        }
    }

    protected byte[] maybeConvertSignatureToVerify(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.algorithmName_ != null && this.algorithmName_.endsWith(P1363_FORMAT_SUFFIX)) {
            ECKey eCKey = (ECKey)((Object)this.key_);
            int n3 = (eCKey.getParams().getOrder().bitLength() + 7) / 8;
            return EvpSignatureBase.ieeeP1363toAsn1(byArray, n, n2, n3);
        }
        return null;
    }

    protected byte[] maybeConvertSignatureToReturn(byte[] byArray) throws SignatureException {
        if (this.algorithmName_ != null && this.algorithmName_.endsWith(P1363_FORMAT_SUFFIX)) {
            ECKey eCKey = (ECKey)((Object)this.key_);
            int n = (eCKey.getParams().getOrder().bitLength() + 7) / 8;
            return EvpSignatureBase.asn1ToiIeeeP1363(byArray, n);
        }
        return byArray;
    }

    protected static byte[] ieeeP1363toAsn1(byte[] byArray, int n, int n2, int n3) throws SignatureException {
        byte[] byArray2;
        if (2 * n3 != n2) {
            throw new SignatureException();
        }
        byte[] byArray3 = new BigInteger(1, Arrays.copyOfRange(byArray, n, n + n3)).toByteArray();
        byte[] byArray4 = new BigInteger(1, Arrays.copyOfRange(byArray, n + n3, n + 2 * n3)).toByteArray();
        if (byArray3.length > 127 || byArray4.length > 127) {
            throw new SignatureException("R or S value is too large");
        }
        int n4 = byArray3.length + byArray4.length + 4;
        if (n4 <= 127) {
            byArray2 = new byte[]{(byte)(n4 & 0xFF)};
        } else if (n4 <= 256) {
            byArray2 = new byte[]{-127, (byte)(n4 & 0xFF)};
        } else {
            throw new SignatureException("R or S value is too large");
        }
        byte[] byArray5 = new byte[1 + byArray2.length + n4];
        int n5 = 0;
        byArray5[n5++] = 48;
        System.arraycopy(byArray2, 0, byArray5, n5, byArray2.length);
        n5 += byArray2.length;
        byArray5[n5++] = 2;
        byArray5[n5++] = (byte)(byArray3.length & 0xFF);
        System.arraycopy(byArray3, 0, byArray5, n5, byArray3.length);
        n5 += byArray3.length;
        byArray5[n5++] = 2;
        byArray5[n5++] = (byte)(byArray4.length & 0xFF);
        System.arraycopy(byArray4, 0, byArray5, n5, byArray4.length);
        if ((n5 += byArray4.length) != byArray5.length) {
            throw new AssertionError((Object)("Final position of " + n5 + " does not match expected value of " + byArray5.length));
        }
        return byArray5;
    }

    protected static byte[] asn1ToiIeeeP1363(byte[] byArray, int n) throws SignatureException {
        int n2;
        int n3 = 0;
        if (byArray[n3++] != 48) {
            throw new AssertionError();
        }
        if ((n2 = Byte.toUnsignedInt(byArray[n3++])) == 129) {
            n2 = Byte.toUnsignedInt(byArray[n3++]);
        } else if (n2 > 127) {
            throw new AssertionError();
        }
        if (n2 != byArray.length - n3) {
            throw new AssertionError();
        }
        int n4 = n3;
        if (byArray[n4] != 2) {
            throw new AssertionError();
        }
        int n5 = n4 + 2;
        int n6 = Byte.toUnsignedInt(byArray[n4 + 1]);
        int n7 = n5 + n6;
        if (byArray[n7] != 2) {
            throw new AssertionError((Object)(Base64.getEncoder().encodeToString(byArray) + " : " + String.format("%x, %x, %x", byArray[n7 - 1], byArray[n7], byArray[n7 + 1])));
        }
        int n8 = Byte.toUnsignedInt(byArray[n7 + 1]);
        int n9 = n7 + 2;
        if (byArray[n5] == 0) {
            ++n5;
            --n6;
        }
        if (byArray[n9] == 0) {
            ++n9;
            --n8;
        }
        byte[] byArray2 = new byte[n * 2];
        System.arraycopy(byArray, n5, byArray2, n - n6, n6);
        System.arraycopy(byArray, n9, byArray2, n + n - n8, n8);
        return byArray2;
    }

    protected static final class EvpContext
    extends NativeResource {
        protected EvpContext(long l2) {
            super(l2, l -> EvpSignatureBase.destroyContext(l));
        }
    }
}

