/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.fqltool.ResultHandler;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DriverResultSet
implements ResultHandler.ComparableResultSet {
    private final ResultSet resultSet;
    private final Throwable failureException;

    public DriverResultSet(ResultSet resultSet) {
        this(resultSet, null);
    }

    private DriverResultSet(ResultSet res, Throwable failureException) {
        this.resultSet = res;
        this.failureException = failureException;
    }

    public static DriverResultSet failed(Throwable ex) {
        return new DriverResultSet(null, ex);
    }

    @Override
    public ResultHandler.ComparableColumnDefinitions getColumnDefinitions() {
        if (this.wasFailed()) {
            return new DriverColumnDefinitions(null, true, this.failureException);
        }
        return new DriverColumnDefinitions(this.resultSet.getColumnDefinitions());
    }

    @Override
    public boolean wasFailed() {
        return this.failureException != null;
    }

    @Override
    public Throwable getFailureException() {
        return this.failureException;
    }

    @Override
    public Iterator<ResultHandler.ComparableRow> iterator() {
        if (this.wasFailed()) {
            return Collections.emptyListIterator();
        }
        return new AbstractIterator<ResultHandler.ComparableRow>(){
            Iterator<Row> iter;
            {
                this.iter = DriverResultSet.this.resultSet.iterator();
            }

            protected ResultHandler.ComparableRow computeNext() {
                if (this.iter.hasNext()) {
                    return new DriverRow(this.iter.next());
                }
                return (ResultHandler.ComparableRow)this.endOfData();
            }
        };
    }

    public static class DriverDefinition
    implements ResultHandler.ComparableDefinition {
        private final ColumnDefinitions.Definition def;

        public DriverDefinition(ColumnDefinitions.Definition def) {
            this.def = def;
        }

        @Override
        public String getType() {
            return this.def.getType().toString();
        }

        @Override
        public String getName() {
            return this.def.getName();
        }

        public boolean equals(Object oo) {
            if (!(oo instanceof ResultHandler.ComparableDefinition)) {
                return false;
            }
            return this.def.equals((Object)((DriverDefinition)oo).def);
        }

        public int hashCode() {
            return Objects.hash(this.def);
        }

        public String toString() {
            return this.getName() + ":" + this.getType();
        }
    }

    public static class DriverColumnDefinitions
    implements ResultHandler.ComparableColumnDefinitions {
        private final ColumnDefinitions columnDefinitions;
        private final boolean failed;
        private final Throwable failureException;

        public DriverColumnDefinitions(ColumnDefinitions columnDefinitions) {
            this(columnDefinitions, false, null);
        }

        private DriverColumnDefinitions(ColumnDefinitions columnDefinitions, boolean failed, Throwable failureException) {
            this.columnDefinitions = columnDefinitions;
            this.failed = failed;
            this.failureException = failureException;
        }

        @Override
        public List<ResultHandler.ComparableDefinition> asList() {
            if (this.wasFailed()) {
                return Collections.emptyList();
            }
            return this.columnDefinitions.asList().stream().map(DriverDefinition::new).collect(Collectors.toList());
        }

        @Override
        public boolean wasFailed() {
            return this.failed;
        }

        @Override
        public Throwable getFailureException() {
            return this.failureException;
        }

        @Override
        public int size() {
            return this.columnDefinitions.size();
        }

        @Override
        public Iterator<ResultHandler.ComparableDefinition> iterator() {
            return this.asList().iterator();
        }

        public boolean equals(Object oo) {
            if (!(oo instanceof ResultHandler.ComparableColumnDefinitions)) {
                return false;
            }
            ResultHandler.ComparableColumnDefinitions o = (ResultHandler.ComparableColumnDefinitions)oo;
            if (this.wasFailed() && o.wasFailed()) {
                return true;
            }
            if (this.size() != o.size()) {
                return false;
            }
            return this.asList().equals(o.asList());
        }

        public int hashCode() {
            return Objects.hash(this.columnDefinitions, this.failed, this.failureException);
        }
    }

    public static class DriverRow
    implements ResultHandler.ComparableRow {
        private final Row row;

        public DriverRow(Row row) {
            this.row = row;
        }

        @Override
        public ResultHandler.ComparableColumnDefinitions getColumnDefinitions() {
            return new DriverColumnDefinitions(this.row.getColumnDefinitions());
        }

        @Override
        public ByteBuffer getBytesUnsafe(int i) {
            return this.row.getBytesUnsafe(i);
        }

        public boolean equals(Object oo) {
            if (!(oo instanceof ResultHandler.ComparableRow)) {
                return false;
            }
            ResultHandler.ComparableRow o = (ResultHandler.ComparableRow)oo;
            if (this.getColumnDefinitions().size() != o.getColumnDefinitions().size()) {
                return false;
            }
            for (int j = 0; j < this.getColumnDefinitions().size(); ++j) {
                ByteBuffer b1 = this.getBytesUnsafe(j);
                ByteBuffer b2 = o.getBytesUnsafe(j);
                if (b1 != null && b2 != null && !b1.equals(b2)) {
                    return false;
                }
                if ((b1 != null || b2 == null) && (b2 != null || b1 == null)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.row);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            List<ResultHandler.ComparableDefinition> colDefs = this.getColumnDefinitions().asList();
            for (int i = 0; i < this.getColumnDefinitions().size(); ++i) {
                ByteBuffer bb = this.getBytesUnsafe(i);
                String row = bb != null ? ByteBufferUtil.bytesToHex((ByteBuffer)bb) : "NULL";
                sb.append(colDefs.get(i)).append(':').append(row).append(",");
            }
            return sb.toString();
        }
    }
}

