/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.ReadMarshallable;
import org.apache.cassandra.fqltool.ResultHandler;
import org.apache.cassandra.fqltool.ResultStore;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class StoredResultSet
implements ResultHandler.ComparableResultSet {
    private final ResultHandler.ComparableColumnDefinitions defs;
    public final boolean hasMoreResultSets;
    private final Supplier<Iterator<ResultHandler.ComparableRow>> rowIteratorSupplier;
    private final boolean wasFailed;
    private final Throwable failureException;

    public StoredResultSet(ResultHandler.ComparableColumnDefinitions defs, boolean hasMoreResultSets, boolean wasFailed, Throwable failure, Supplier<Iterator<ResultHandler.ComparableRow>> iteratorSupplier) {
        this.defs = defs;
        this.hasMoreResultSets = hasMoreResultSets;
        this.wasFailed = wasFailed;
        this.failureException = failure;
        this.rowIteratorSupplier = iteratorSupplier;
    }

    public static StoredResultSet fromTailer(final ExcerptTailer tailer) {
        ResultStore.ColumnDefsReader reader = new ResultStore.ColumnDefsReader();
        boolean hasMoreResultSets = tailer.readDocument((ReadMarshallable)reader);
        final StoredComparableColumnDefinitions defs = new StoredComparableColumnDefinitions(reader.columnDefinitions, reader.wasFailed, new RuntimeException(reader.failureMessage));
        AbstractIterator<ResultHandler.ComparableRow> rowIterator = new AbstractIterator<ResultHandler.ComparableRow>(){

            protected ResultHandler.ComparableRow computeNext() {
                ResultStore.RowReader rowReader = new ResultStore.RowReader();
                tailer.readDocument((ReadMarshallable)rowReader);
                if (rowReader.isFinished) {
                    return (ResultHandler.ComparableRow)this.endOfData();
                }
                return new StoredComparableRow(rowReader.rows, defs);
            }
        };
        return new StoredResultSet(defs, hasMoreResultSets, reader.wasFailed, new RuntimeException(reader.failureMessage), () -> StoredResultSet.lambda$fromTailer$0((Iterator)rowIterator));
    }

    public static ResultHandler.ComparableResultSet failed(String failureMessage) {
        return new FailedComparableResultSet(new RuntimeException(failureMessage));
    }

    @Override
    public Iterator<ResultHandler.ComparableRow> iterator() {
        return this.rowIteratorSupplier.get();
    }

    @Override
    public ResultHandler.ComparableColumnDefinitions getColumnDefinitions() {
        return this.defs;
    }

    @Override
    public boolean wasFailed() {
        return this.wasFailed;
    }

    @Override
    public Throwable getFailureException() {
        return this.failureException;
    }

    private static /* synthetic */ Iterator lambda$fromTailer$0(Iterator rowIterator) {
        return rowIterator;
    }

    private static class FailedComparableResultSet
    implements ResultHandler.ComparableResultSet {
        private final Throwable exception;

        public FailedComparableResultSet(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public ResultHandler.ComparableColumnDefinitions getColumnDefinitions() {
            return new ResultHandler.ComparableColumnDefinitions(){

                @Override
                public List<ResultHandler.ComparableDefinition> asList() {
                    return Collections.emptyList();
                }

                @Override
                public boolean wasFailed() {
                    return true;
                }

                @Override
                public Throwable getFailureException() {
                    return exception;
                }

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public Iterator<ResultHandler.ComparableDefinition> iterator() {
                    return this.asList().iterator();
                }
            };
        }

        @Override
        public boolean wasFailed() {
            return true;
        }

        @Override
        public Throwable getFailureException() {
            return new RuntimeException();
        }

        @Override
        public Iterator<ResultHandler.ComparableRow> iterator() {
            return Collections.emptyListIterator();
        }
    }

    private static class StoredComparableDefinition
    implements ResultHandler.ComparableDefinition {
        private final Pair<String, String> p;

        public StoredComparableDefinition(Pair<String, String> p) {
            this.p = p;
        }

        @Override
        public String getType() {
            return (String)this.p.right;
        }

        @Override
        public String getName() {
            return (String)this.p.left;
        }

        public boolean equals(Object other) {
            if (!(other instanceof StoredComparableDefinition)) {
                return false;
            }
            return this.p.equals(((StoredComparableDefinition)other).p);
        }

        public int hashCode() {
            return Objects.hash(this.p);
        }

        public String toString() {
            return this.getName() + ":" + this.getType();
        }
    }

    static class StoredComparableColumnDefinitions
    implements ResultHandler.ComparableColumnDefinitions {
        private final List<ResultHandler.ComparableDefinition> defs;
        private final boolean wasFailed;
        private final Throwable failureException;

        public StoredComparableColumnDefinitions(List<Pair<String, String>> cds, boolean wasFailed, Throwable failureException) {
            this.defs = cds != null ? cds.stream().map(StoredComparableDefinition::new).collect(Collectors.toList()) : Collections.emptyList();
            this.wasFailed = wasFailed;
            this.failureException = failureException;
        }

        @Override
        public List<ResultHandler.ComparableDefinition> asList() {
            return this.wasFailed() ? Collections.emptyList() : this.defs;
        }

        @Override
        public boolean wasFailed() {
            return this.wasFailed;
        }

        @Override
        public Throwable getFailureException() {
            return this.failureException;
        }

        @Override
        public int size() {
            return this.asList().size();
        }

        @Override
        public Iterator<ResultHandler.ComparableDefinition> iterator() {
            return this.defs.iterator();
        }

        public boolean equals(Object other) {
            if (!(other instanceof StoredComparableColumnDefinitions)) {
                return false;
            }
            return this.defs.equals(((StoredComparableColumnDefinitions)other).defs);
        }

        public int hashCode() {
            return Objects.hash(this.defs, this.wasFailed, this.failureException);
        }

        public String toString() {
            return this.defs.toString();
        }
    }

    static class StoredComparableRow
    implements ResultHandler.ComparableRow {
        private final List<ByteBuffer> row;
        private final ResultHandler.ComparableColumnDefinitions cds;

        public StoredComparableRow(List<ByteBuffer> row, ResultHandler.ComparableColumnDefinitions cds) {
            this.row = row;
            this.cds = cds;
        }

        @Override
        public ByteBuffer getBytesUnsafe(int i) {
            return this.row.get(i);
        }

        @Override
        public ResultHandler.ComparableColumnDefinitions getColumnDefinitions() {
            return this.cds;
        }

        public boolean equals(Object other) {
            if (!(other instanceof StoredComparableRow)) {
                return false;
            }
            return this.row.equals(((StoredComparableRow)other).row);
        }

        public int hashCode() {
            return Objects.hash(this.row, this.cds);
        }

        public String toString() {
            return this.row.stream().map(ByteBufferUtil::bytesToHex).collect(Collectors.joining(","));
        }
    }
}

