/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.io.Serializable;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jira157TestCase
extends TestCase {
    private final Log log = LogFactory.getLog(Jira157TestCase.class);

    public static void main(String[] args) {
        TestRunner.run((Test)Jira157TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira157TestCase.class);
    }

    public Jira157TestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        BeanUtilsBean custom = new BeanUtilsBean();
        custom.getPropertyUtils().removeBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
        BeanUtilsBean.setInstance((BeanUtilsBean)custom);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIssue_BEANUTILS_157_BeanUtils_Describe_Bean() {
        FooBar bean = new FooBar();
        Map result = null;
        try {
            result = BeanUtils.describe((Object)bean);
        }
        catch (Throwable t) {
            this.log.error((Object)("Describe Bean: " + t.getMessage()), t);
            Jira157TestCase.fail((String)("Describe Bean Threw exception: " + t));
        }
        Jira157TestCase.assertEquals((String)"Check Size", (int)2, (int)result.size());
        Jira157TestCase.assertTrue((String)"Class", (boolean)result.containsKey("class"));
        Jira157TestCase.assertTrue((String)"publicFoo Key", (boolean)result.containsKey("publicFoo"));
        Jira157TestCase.assertEquals((String)"publicFoo Value", (String)"PublicFoo Value", (String)((String)result.get("publicFoo")));
    }

    public void testIssue_BEANUTILS_157_BeanUtils_Describe_Interface() {
        XY bean = new XY(){

            @Override
            public String getX() {
                return "x-value";
            }

            @Override
            public String getY() {
                return "y-value";
            }
        };
        Map result = null;
        try {
            result = BeanUtils.describe((Object)bean);
        }
        catch (Throwable t) {
            this.log.error((Object)("Describe Interface: " + t.getMessage()), t);
            Jira157TestCase.fail((String)("Describe Interface Threw exception: " + t));
        }
        Jira157TestCase.assertEquals((String)"Check Size", (int)3, (int)result.size());
        Jira157TestCase.assertTrue((String)"Class", (boolean)result.containsKey("class"));
        Jira157TestCase.assertTrue((String)"X Key", (boolean)result.containsKey("x"));
        Jira157TestCase.assertTrue((String)"Y Key", (boolean)result.containsKey("y"));
        Jira157TestCase.assertEquals((String)"X Value", (String)"x-value", (String)((String)result.get("x")));
        Jira157TestCase.assertEquals((String)"Y Value", (String)"y-value", (String)((String)result.get("y")));
    }

    public void testIssue_BEANUTILS_157_BeanUtils_Describe_Serializable() {
        Serializable bean = new Serializable(){
            private static final long serialVersionUID = 1L;

            public String getX() {
                return "x-value";
            }

            public String getY() {
                return "y-value";
            }
        };
        Map result = null;
        try {
            result = BeanUtils.describe((Object)bean);
        }
        catch (Throwable t) {
            this.log.error((Object)("Describe Serializable: " + t.getMessage()), t);
            Jira157TestCase.fail((String)("Describe Serializable Threw exception: " + t));
        }
        Jira157TestCase.assertEquals((String)"Check Size", (int)1, (int)result.size());
        Jira157TestCase.assertTrue((String)"Class", (boolean)result.containsKey("class"));
    }

    public static class FooBar {
        String getPackageFoo() {
            return "Package Value";
        }

        private String getPrivateFoo() {
            return "PrivateFoo Value";
        }

        protected String getProtectedFoo() {
            return "ProtectedFoo Value";
        }

        public String getPublicFoo() {
            return "PublicFoo Value";
        }
    }

    public static interface XY {
        public String getX();

        public String getY();
    }
}

