/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.beanutils2.BeanIntrospectionData;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.FluentIntrospectionTestBean;
import org.apache.commons.beanutils2.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.beanutils2.SuppressPropertiesBeanIntrospector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanIntrospectionDataTest {
    private static final Class<?> BEAN_CLASS = FluentIntrospectionTestBean.class;
    private static final String TEST_PROP = "fluentGetProperty";

    private static PropertyDescriptor[] fetchDescriptors() {
        PropertyUtilsBean pub = new PropertyUtilsBean();
        pub.removeBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
        pub.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        return pub.getPropertyDescriptors(BEAN_CLASS);
    }

    private static PropertyDescriptor fetchTestDescriptor(BeanIntrospectionData bid) {
        return bid.getDescriptor(TEST_PROP);
    }

    private static BeanIntrospectionData setUpData() {
        return new BeanIntrospectionData(BeanIntrospectionDataTest.fetchDescriptors());
    }

    @Test
    public void testGetWriteMethodDefined() {
        BeanIntrospectionData data = BeanIntrospectionDataTest.setUpData();
        PropertyDescriptor pd = BeanIntrospectionDataTest.fetchTestDescriptor(data);
        Assertions.assertNotNull((Object)pd.getWriteMethod(), (String)"No write method");
        Assertions.assertEquals((Object)pd.getWriteMethod(), (Object)data.getWriteMethod(BEAN_CLASS, pd), (String)"Wrong write method");
    }

    @Test
    public void testGetWriteMethodNonExisting() throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(TEST_PROP, BEAN_CLASS.getMethod("getFluentGetProperty", new Class[0]), BEAN_CLASS.getMethod("setFluentGetProperty", String.class));
        HashMap<String, String> methods = new HashMap<String, String>();
        methods.put(TEST_PROP, "hashCode");
        BeanIntrospectionData data = new BeanIntrospectionData(new PropertyDescriptor[]{pd}, methods);
        pd.setWriteMethod(null);
        Assertions.assertNull((Object)data.getWriteMethod(BEAN_CLASS, pd), (String)"Got a write method");
    }

    @Test
    public void testGetWriteMethodUndefined() throws Exception {
        BeanIntrospectionData data = BeanIntrospectionDataTest.setUpData();
        PropertyDescriptor pd = BeanIntrospectionDataTest.fetchTestDescriptor(data);
        Method writeMethod = pd.getWriteMethod();
        pd.setWriteMethod(null);
        Assertions.assertEquals((Object)writeMethod, (Object)data.getWriteMethod(BEAN_CLASS, pd), (String)"Wrong write method");
        Assertions.assertEquals((Object)writeMethod, (Object)pd.getWriteMethod(), (String)"Method not set in descriptor");
    }

    @Test
    public void testGetWriteMethodUnknown() {
        BeanIntrospectionData data = BeanIntrospectionDataTest.setUpData();
        PropertyDescriptor pd = data.getDescriptor("class");
        Assertions.assertNull((Object)data.getWriteMethod(BEAN_CLASS, pd), (String)"Got a write method");
    }
}

