/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DisablePartialMatchingTest {
    DisablePartialMatchingTest() {
    }

    @Test
    void testDisablePartialMatching() throws Exception {
        DefaultParser parser = new DefaultParser(false);
        Options options = new Options();
        options.addOption(new Option("d", "debug", false, "Turn on debug."));
        options.addOption(new Option("e", "extract", false, "Turn on extract."));
        options.addOption(new Option("o", "option", true, "Turn on option with argument."));
        CommandLine line = parser.parse(options, new String[]{"-de", "--option=foobar"});
        Assertions.assertTrue((boolean)line.hasOption("debug"), (String)"There should be an option debug in any case...");
        Assertions.assertTrue((boolean)line.hasOption("extract"), (String)"There should be an extract option because partial matching is off");
        Assertions.assertTrue((boolean)line.hasOption("option"), (String)"There should be an option option with a argument value");
    }

    @Test
    void testRegularPartialMatching() throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(new Option("d", "debug", false, "Turn on debug."));
        options.addOption(new Option("e", "extract", false, "Turn on extract."));
        options.addOption(new Option("o", "option", true, "Turn on option with argument."));
        CommandLine line = parser.parse(options, new String[]{"-de", "--option=foobar"});
        Assertions.assertTrue((boolean)line.hasOption("debug"), (String)"There should be an option debug in any case...");
        Assertions.assertFalse((boolean)line.hasOption("extract"), (String)"There should not be an extract option because partial matching only selects debug");
        Assertions.assertTrue((boolean)line.hasOption("option"), (String)"There should be an option option with a argument value");
    }
}

