/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.EnumFixture;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBaseConfiguration {
    static final String KEY_NUMBER = "number";
    protected static Class<?> missingElementException = NoSuchElementException.class;
    protected static Class<?> incompatibleElementException = ConversionException.class;
    protected BaseConfiguration config;

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new BaseConfiguration();
        this.config.setThrowExceptionOnMissing(true);
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
    }

    @Test
    public void testAddProperty() throws Exception {
        ArrayList<Object> props = new ArrayList<Object>();
        props.add("one");
        props.add("two,three,four");
        props.add(new String[]{"5.1", "5.2", "5.3,5.4", "5.5"});
        props.add("six");
        this.config.addProperty("complex.property", props);
        Object val = this.config.getProperty("complex.property");
        Collection col = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)val);
        Assertions.assertEquals((int)10, (int)col.size());
        props = new ArrayList();
        props.add("quick");
        props.add("brown");
        props.add("fox,jumps");
        Object[] data = new Object[]{"The", props, "over,the", "lazy", "dog."};
        this.config.setProperty("complex.property", (Object)data);
        val = this.config.getProperty("complex.property");
        col = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)val);
        Iterator it = col.iterator();
        StringTokenizer tok = new StringTokenizer("The quick brown fox jumps over the lazy dog.", " ");
        while (tok.hasMoreTokens()) {
            Assertions.assertTrue((boolean)it.hasNext());
            Assertions.assertEquals((Object)tok.nextToken(), it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
        this.config.setProperty("complex.property", null);
        Assertions.assertFalse((boolean)this.config.containsKey("complex.property"));
    }

    @Test
    public void testClone() {
        for (int i = 0; i < 10; ++i) {
            this.config.addProperty("key" + i, (Object)i);
        }
        BaseConfiguration config2 = (BaseConfiguration)this.config.clone();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertTrue((boolean)config2.containsKey(key), (String)("Key not found: " + key));
            Assertions.assertEquals((Object)this.config.getProperty(key), (Object)config2.getProperty(key), (String)("Wrong value for key " + key));
        }
    }

    @Test
    public void testCloneInterpolation() {
        String keyAnswer = "answer";
        this.config.addProperty("answer", (Object)"The answer is ${number}.");
        this.config.addProperty(KEY_NUMBER, (Object)42);
        BaseConfiguration clone = (BaseConfiguration)this.config.clone();
        clone.setProperty(KEY_NUMBER, (Object)43);
        Assertions.assertEquals((Object)"The answer is 42.", (Object)this.config.getString("answer"));
        Assertions.assertEquals((Object)"The answer is 43.", (Object)clone.getString("answer"));
    }

    @Test
    public void testCloneListProperty() {
        String key = "list";
        this.config.addProperty("list", (Object)"value1");
        this.config.addProperty("list", (Object)"value2");
        BaseConfiguration config2 = (BaseConfiguration)this.config.clone();
        config2.addProperty("list", (Object)"value3");
        Assertions.assertEquals((int)2, (int)this.config.getList("list").size());
    }

    @Test
    public void testCloneModify() {
        EventListenerTestImpl l = new EventListenerTestImpl(this.config);
        this.config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        this.config.addProperty("original", (Object)Boolean.TRUE);
        BaseConfiguration config2 = (BaseConfiguration)this.config.clone();
        config2.addProperty("clone", (Object)Boolean.TRUE);
        Assertions.assertFalse((boolean)this.config.containsKey("clone"));
        config2.setProperty("original", (Object)Boolean.FALSE);
        Assertions.assertTrue((boolean)this.config.getBoolean("original"));
        Assertions.assertTrue((boolean)config2.getEventListeners(ConfigurationEvent.ANY).isEmpty());
    }

    @Test
    public void testCommaSeparatedString() {
        String prop = "hey, that's a test";
        this.config.setProperty("prop.string", (Object)"hey, that's a test");
        List list = this.config.getList("prop.string");
        Assertions.assertEquals(Arrays.asList("hey", "that's a test"), (Object)list);
    }

    @Test
    public void testCommaSeparatedStringEscaped() {
        String prop2 = "hey\\, that's a test";
        this.config.setProperty("prop.string", (Object)"hey\\, that's a test");
        Assertions.assertEquals((Object)"hey, that's a test", (Object)this.config.getString("prop.string"));
    }

    @Test
    public void testContainsValue() {
        Assertions.assertFalse((boolean)this.config.containsValue(null));
    }

    @Test
    public void testGetBigDecimal() {
        this.config.setProperty("numberBigD", (Object)"123.456");
        BigDecimal number = new BigDecimal("123.456");
        BigDecimal defaultValue = new BigDecimal("654.321");
        Assertions.assertEquals((Object)number, (Object)this.config.getBigDecimal("numberBigD"));
        Assertions.assertEquals((Object)number, (Object)this.config.getBigDecimal("numberBigD", defaultValue));
        Assertions.assertEquals((Object)defaultValue, (Object)this.config.getBigDecimal("numberNotInConfig", defaultValue));
    }

    @Test
    public void testGetBigDecimalIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getBigDecimal("test.empty"));
    }

    @Test
    public void testGetBigDecimalUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getBigDecimal("numberNotInConfig"));
    }

    @Test
    public void testGetBigInteger() {
        this.config.setProperty("numberBigI", (Object)"1234567890");
        BigInteger number = new BigInteger("1234567890");
        BigInteger defaultValue = new BigInteger("654321");
        Assertions.assertEquals((Object)number, (Object)this.config.getBigInteger("numberBigI"));
        Assertions.assertEquals((Object)number, (Object)this.config.getBigInteger("numberBigI", defaultValue));
        Assertions.assertEquals((Object)defaultValue, (Object)this.config.getBigInteger("numberNotInConfig", defaultValue));
    }

    @Test
    public void testGetBigIntegerIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getBigInteger("test.empty"));
    }

    @Test
    public void testGetBigIntegerUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getBigInteger("numberNotInConfig"));
    }

    @Test
    public void testGetBinaryValue() {
        this.config.setProperty(KEY_NUMBER, (Object)"0b11111111");
        Assertions.assertEquals((byte)-1, (byte)this.config.getByte(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0b1111111111111111");
        Assertions.assertEquals((short)-1, (short)this.config.getShort(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0b11111111111111111111111111111111");
        Assertions.assertEquals((int)-1, (int)this.config.getInt(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0b1111111111111111111111111111111111111111111111111111111111111111");
        Assertions.assertEquals((long)-1L, (long)this.config.getLong(KEY_NUMBER));
        Assertions.assertEquals((long)-1L, (long)this.config.getBigInteger(KEY_NUMBER).longValue());
    }

    @Test
    public void testGetBoolean() {
        this.config.setProperty("boolA", (Object)Boolean.TRUE);
        boolean boolT = true;
        boolean boolF = false;
        Assertions.assertEquals((Object)true, (Object)this.config.getBoolean("boolA"));
        Assertions.assertEquals((Object)true, (Object)this.config.getBoolean("boolA", false));
        Assertions.assertEquals((Object)false, (Object)this.config.getBoolean("boolNotInConfig", false));
        Assertions.assertEquals((Object)true, (Object)this.config.getBoolean("boolA", Boolean.valueOf(false)));
    }

    @Test
    public void testGetBooleanIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getBoolean("test.empty"));
    }

    @Test
    public void testGetBooleanUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getBoolean("numberNotInConfig"));
    }

    @Test
    public void testGetByte() {
        this.config.setProperty(KEY_NUMBER, (Object)"1");
        boolean oneB = true;
        int twoB = 2;
        Assertions.assertEquals((byte)1, (byte)this.config.getByte(KEY_NUMBER));
        Assertions.assertEquals((byte)1, (byte)this.config.getByte(KEY_NUMBER, (byte)2));
        Assertions.assertEquals((byte)2, (byte)this.config.getByte("numberNotInConfig", (byte)2));
        Assertions.assertEquals((Byte)1, (Byte)this.config.getByte(KEY_NUMBER, Byte.valueOf("2")));
    }

    @Test
    public void testGetByteIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getByte("test.empty"));
    }

    @Test
    public void testGetByteUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getByte("numberNotInConfig"));
    }

    @Test
    public void testGetDouble() {
        this.config.setProperty("numberD", (Object)"1.0");
        double oneD = 1.0;
        double twoD = 2.0;
        Assertions.assertEquals((double)1.0, (double)this.config.getDouble("numberD"), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)this.config.getDouble("numberD", 2.0), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)this.config.getDouble("numberNotInConfig", 2.0), (double)0.0);
        Assertions.assertEquals((Double)1.0, (Double)this.config.getDouble("numberD", Double.valueOf("2")));
    }

    @Test
    public void testGetDoubleIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getDouble("test.empty"));
    }

    @Test
    public void testGetDoubleUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getDouble("numberNotInConfig"));
    }

    @Test
    public void testGetDuration() {
        Duration d = Duration.ofSeconds(1L);
        this.config.setProperty("durationD", (Object)d.toString());
        Duration oneD = Duration.ofSeconds(1L);
        Duration twoD = Duration.ofSeconds(2L);
        Assertions.assertEquals((Object)oneD, (Object)this.config.getDuration("durationD"));
        Assertions.assertEquals((Object)oneD, (Object)this.config.getDuration("durationD", twoD));
        Assertions.assertEquals((Object)twoD, (Object)this.config.getDuration("numberNotInConfig", twoD));
        Assertions.assertEquals((Object)oneD, (Object)this.config.getDuration("durationD", twoD));
    }

    @Test
    public void testGetDurationIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getDuration("test.empty"));
    }

    @Test
    public void testGetDurationUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getDuration("numberNotInConfig"));
    }

    @Test
    public void testGetEnum() {
        this.config.setProperty("testEnum", (Object)EnumFixture.SMALLTALK.name());
        this.config.setProperty("testBadEnum", (Object)"This is not an enum value.");
        EnumFixture enum1 = EnumFixture.SMALLTALK;
        EnumFixture defaultValue = EnumFixture.JAVA;
        Assertions.assertEquals((Object)((Object)enum1), (Object)this.config.getEnum("testEnum", EnumFixture.class));
        Assertions.assertEquals((Object)((Object)enum1), (Object)this.config.getEnum("testEnum", EnumFixture.class, (Enum)defaultValue));
        Assertions.assertEquals((Object)((Object)defaultValue), (Object)this.config.getEnum("stringNotInConfig", EnumFixture.class, (Enum)defaultValue));
        Assertions.assertThrows(ConversionException.class, () -> this.config.getEnum("testBadEnum", EnumFixture.class));
        Assertions.assertThrows(ConversionException.class, () -> this.config.getEnum("testBadEnum", EnumFixture.class, (Enum)defaultValue));
    }

    @Test
    public void testGetFloat() {
        this.config.setProperty("numberF", (Object)"1.0");
        float oneF = 1.0f;
        float twoF = 2.0f;
        Assertions.assertEquals((float)1.0f, (float)this.config.getFloat("numberF"), (float)0.0f);
        Assertions.assertEquals((float)1.0f, (float)this.config.getFloat("numberF", 2.0f), (float)0.0f);
        Assertions.assertEquals((float)2.0f, (float)this.config.getFloat("numberNotInConfig", 2.0f), (float)0.0f);
        Assertions.assertEquals((Float)Float.valueOf(1.0f), (Float)this.config.getFloat("numberF", Float.valueOf("2")));
    }

    @Test
    public void testGetFloatIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getFloat("test.empty"));
    }

    @Test
    public void testGetFloatUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getFloat("numberNotInConfig"));
    }

    @Test
    public void testGetHexadecimalValue() {
        this.config.setProperty(KEY_NUMBER, (Object)"0xFF");
        Assertions.assertEquals((byte)-1, (byte)this.config.getByte(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0xFFFF");
        Assertions.assertEquals((short)-1, (short)this.config.getShort(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0xFFFFFFFF");
        Assertions.assertEquals((int)-1, (int)this.config.getInt(KEY_NUMBER));
        this.config.setProperty(KEY_NUMBER, (Object)"0xFFFFFFFFFFFFFFFF");
        Assertions.assertEquals((long)-1L, (long)this.config.getLong(KEY_NUMBER));
        Assertions.assertEquals((long)-1L, (long)this.config.getBigInteger(KEY_NUMBER).longValue());
    }

    @Test
    public void testGetInterpolatedList() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty("array", (Object)"${number}");
        this.config.addProperty("array", (Object)"${number}");
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("1");
        Assertions.assertEquals(list, (Object)this.config.getList("array"));
    }

    @Test
    public void testGetInterpolatedPrimitives() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty("value", (Object)"${number}");
        this.config.addProperty("boolean", (Object)"true");
        this.config.addProperty("booleanValue", (Object)"${boolean}");
        Assertions.assertTrue((boolean)this.config.getBoolean("booleanValue"));
        Assertions.assertEquals((int)1, (int)this.config.getByte("value"));
        Assertions.assertEquals((int)1, (int)this.config.getShort("value"));
        Assertions.assertEquals((int)1, (int)this.config.getInt("value"));
        Assertions.assertEquals((long)1L, (long)this.config.getLong("value"));
        Assertions.assertEquals((float)1.0f, (float)this.config.getFloat("value"), (float)0.0f);
        Assertions.assertEquals((double)1.0, (double)this.config.getDouble("value"), (double)0.0);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.config.getBoolean("booleanValue", null));
        Assertions.assertEquals((Byte)Byte.valueOf("1"), (Byte)this.config.getByte("value", null));
        Assertions.assertEquals((Short)Short.valueOf("1"), (Short)this.config.getShort("value", null));
        Assertions.assertEquals((Integer)Integer.valueOf("1"), (Integer)this.config.getInteger("value", null));
        Assertions.assertEquals((Long)Long.valueOf("1"), (Long)this.config.getLong("value", null));
        Assertions.assertEquals((Float)Float.valueOf("1"), (Float)this.config.getFloat("value", null));
        Assertions.assertEquals((Double)Double.valueOf("1"), (Double)this.config.getDouble("value", null));
        Assertions.assertEquals((Object)new BigInteger("1"), (Object)this.config.getBigInteger("value", null));
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)this.config.getBigDecimal("value", null));
    }

    @Test
    public void testGetInterpolator() {
        InterpolationTestHelper.testGetInterpolator((AbstractConfiguration)this.config);
    }

    @Test
    public void testGetList() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty(KEY_NUMBER, (Object)"2");
        List list = this.config.getList(KEY_NUMBER);
        Assertions.assertEquals(Arrays.asList("1", "2"), (Object)list);
    }

    @Test
    public void testGetLong() {
        this.config.setProperty("numberL", (Object)"1");
        long oneL = 1L;
        long twoL = 2L;
        Assertions.assertEquals((long)1L, (long)this.config.getLong("numberL"));
        Assertions.assertEquals((long)1L, (long)this.config.getLong("numberL", 2L));
        Assertions.assertEquals((long)2L, (long)this.config.getLong("numberNotInConfig", 2L));
        Assertions.assertEquals((Long)1L, (Long)this.config.getLong("numberL", Long.valueOf("2")));
    }

    @Test
    public void testGetLongIncompatibleTypes() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getLong("test.empty"));
    }

    @Test
    public void testGetLongUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getLong("numberNotInConfig"));
    }

    @Test
    public void testGetProperty() {
        Assertions.assertNull((Object)this.config.getProperty("foo"));
        this.config.setProperty(KEY_NUMBER, (Object)"1");
        Assertions.assertEquals((Object)"1", (Object)this.config.getProperty(KEY_NUMBER));
        Assertions.assertEquals((Object)"1", (Object)this.config.getString(KEY_NUMBER));
    }

    @Test
    public void testGetShort() {
        this.config.setProperty("numberS", (Object)"1");
        boolean oneS = true;
        int twoS = 2;
        Assertions.assertEquals((short)1, (short)this.config.getShort("numberS"));
        Assertions.assertEquals((short)1, (short)this.config.getShort("numberS", (short)2));
        Assertions.assertEquals((short)2, (short)this.config.getShort("numberNotInConfig", (short)2));
        Assertions.assertEquals((Short)1, (Short)this.config.getShort("numberS", Short.valueOf("2")));
    }

    @Test
    public void testGetShortIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getShort("test.empty"));
    }

    @Test
    public void testGetShortUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getShort("numberNotInConfig"));
    }

    @Test
    public void testGetString() {
        this.config.setProperty("testString", (Object)"The quick brown fox");
        String string = "The quick brown fox";
        String defaultValue = "jumps over the lazy dog";
        Assertions.assertEquals((Object)"The quick brown fox", (Object)this.config.getString("testString"));
        Assertions.assertEquals((Object)"The quick brown fox", (Object)this.config.getString("testString", "jumps over the lazy dog"));
        Assertions.assertEquals((Object)"jumps over the lazy dog", (Object)this.config.getString("stringNotInConfig", "jumps over the lazy dog"));
    }

    @Test
    public void testGetStringForListValue() {
        this.config.addProperty(KEY_NUMBER, (Object)"1");
        this.config.addProperty(KEY_NUMBER, (Object)"2");
        Assertions.assertEquals((Object)"1", (Object)this.config.getString(KEY_NUMBER));
    }

    @Test
    public void testGetStringUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getString("stringNotInConfig"));
    }

    @Test
    public void testInstallInterpolator() {
        Lookup prefixLookup = (Lookup)Mockito.mock(Lookup.class);
        Lookup defLookup = (Lookup)Mockito.mock(Lookup.class);
        HashMap<String, Lookup> prefixLookups = new HashMap<String, Lookup>();
        prefixLookups.put("test", prefixLookup);
        ArrayList<Lookup> defLookups = new ArrayList<Lookup>();
        defLookups.add(defLookup);
        this.config.installInterpolator(prefixLookups, defLookups);
        ConfigurationInterpolator interpolator = this.config.getInterpolator();
        Assertions.assertEquals(prefixLookups, (Object)interpolator.getLookups());
        List defLookups2 = interpolator.getDefaultLookups();
        Assertions.assertEquals((int)2, (int)defLookups2.size());
        Assertions.assertSame((Object)defLookup, defLookups2.get(0));
        String var = "testVariable";
        Integer value = 42;
        this.config.addProperty("testVariable", (Object)value);
        Assertions.assertEquals((Object)value, (Object)((Lookup)defLookups2.get(1)).lookup("testVariable"));
    }

    @Test
    public void testInterpolatedConfiguration() {
        InterpolationTestHelper.testInterpolatedConfiguration((AbstractConfiguration)this.config);
    }

    @Test
    public void testInterpolation() {
        InterpolationTestHelper.testInterpolation((Configuration)this.config);
    }

    @Test
    public void testInterpolationConstants() {
        InterpolationTestHelper.testInterpolationConstants((Configuration)this.config);
    }

    @Test
    public void testInterpolationEnvironment() {
        InterpolationTestHelper.testInterpolationEnvironment((Configuration)this.config);
    }

    @Test
    public void testInterpolationEscaped() {
        InterpolationTestHelper.testInterpolationEscaped((Configuration)this.config);
    }

    @Test
    public void testInterpolationLocalhost() {
        InterpolationTestHelper.testInterpolationLocalhost((Configuration)this.config);
    }

    @Test
    public void testInterpolationLoop() {
        InterpolationTestHelper.testInterpolationLoop((Configuration)this.config);
    }

    @Test
    public void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset((Configuration)this.config);
    }

    @Test
    public void testInterpolationSystemProperties() {
        InterpolationTestHelper.testInterpolationSystemProperties((Configuration)this.config);
    }

    @Test
    public void testInterpolationUnknownProperty() {
        InterpolationTestHelper.testInterpolationUnknownProperty((Configuration)this.config);
    }

    @Test
    public void testMultipleInterpolation() {
        InterpolationTestHelper.testMultipleInterpolation((Configuration)this.config);
    }

    @Test
    public void testNoInterpolator() {
        this.config.setProperty("test", (Object)"${value}");
        this.config.setInterpolator(null);
        Assertions.assertEquals((Object)"${value}", (Object)this.config.getString("test"));
    }

    @Test
    public void testNumberConversions() {
        this.config.setProperty(KEY_NUMBER, (Object)42);
        Assertions.assertEquals((int)42, (int)this.config.getInt(KEY_NUMBER));
        Assertions.assertEquals((long)42L, (long)this.config.getLong(KEY_NUMBER));
        Assertions.assertEquals((byte)42, (byte)this.config.getByte(KEY_NUMBER));
        Assertions.assertEquals((float)42.0f, (float)this.config.getFloat(KEY_NUMBER), (float)0.01f);
        Assertions.assertEquals((double)42.0, (double)this.config.getDouble(KEY_NUMBER), (double)0.001);
        Assertions.assertEquals((Long)42L, (Long)this.config.getLong(KEY_NUMBER, null));
        Assertions.assertEquals((Object)new BigInteger("42"), (Object)this.config.getBigInteger(KEY_NUMBER));
        Assertions.assertEquals((Object)new BigDecimal("42.0"), (Object)this.config.getBigDecimal(KEY_NUMBER));
    }

    @Test
    public void testPropertyAccess() {
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"");
        Assertions.assertEquals((Object)new Properties(), (Object)this.config.getProperties("prop.properties"));
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"foo=bar, baz=moo, seal=clubber");
        Properties p = new Properties();
        p.setProperty("foo", "bar");
        p.setProperty("baz", "moo");
        p.setProperty("seal", "clubber");
        Assertions.assertEquals((Object)p, (Object)this.config.getProperties("prop.properties"));
    }

    @Test
    public void testSetInterpolator() {
        ConfigurationInterpolator interpolator = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        this.config.setInterpolator(interpolator);
        Assertions.assertSame((Object)interpolator, (Object)this.config.getInterpolator());
    }

    @Test
    public void testSize() {
        int count = 16;
        for (int i = 0; i < 16; ++i) {
            this.config.addProperty("key" + i, (Object)("value" + i));
        }
        Assertions.assertEquals((int)16, (int)this.config.size());
    }

    @Test
    public void testSubset() {
        String prop = "hey, that's a test";
        String prop2 = "hey\\, that's a test";
        this.config.setProperty("prop.string", (Object)"hey\\, that's a test");
        this.config.setProperty("property.string", (Object)"hello");
        Configuration subEprop = this.config.subset("prop");
        Assertions.assertEquals((Object)"hey, that's a test", (Object)subEprop.getString("string"));
        Assertions.assertEquals((int)1, (int)subEprop.getList("string").size());
        Iterator it = subEprop.getKeys();
        it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        subEprop = this.config.subset("prop.");
        it = subEprop.getKeys();
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assertions.assertTrue((boolean)this.config.isThrowExceptionOnMissing());
    }
}

