/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiWrapDynaBean;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultiWrapDynaBean {
    private static final String MAPPED_PROPERTY = "testMappedProperty";
    private BasicBuilderParameters params;
    private WrappedBeanTestImpl wrapBean;
    private LazyDynaBean wrapDynaBean;

    private MultiWrapDynaBean createBean(boolean withDynaBean) {
        this.params = new BasicBuilderParameters();
        this.wrapBean = new WrappedBeanTestImpl();
        ArrayList<Object> beans = new ArrayList<Object>();
        beans.add(this.params);
        beans.add(this.wrapBean);
        if (withDynaBean) {
            this.wrapDynaBean = new LazyDynaBean();
            this.wrapDynaBean.set(MAPPED_PROPERTY, "someKey", (Object)"somValue");
            beans.add(this.wrapDynaBean);
        }
        return new MultiWrapDynaBean(beans);
    }

    @Test
    public void testContains() {
        MultiWrapDynaBean bean = this.createBean(false);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> bean.contains(MAPPED_PROPERTY, "someKey"));
    }

    @Test
    public void testGetDynaClass() {
        DynaClass cls = this.createBean(false).getDynaClass();
        Assertions.assertNotNull((Object)cls.getDynaProperty("throwExceptionOnMissing"));
        Assertions.assertNotNull((Object)cls.getDynaProperty("text"));
    }

    @Test
    public void testGetDynaClassName() {
        Assertions.assertNull((Object)this.createBean(false).getDynaClass().getName());
    }

    @Test
    public void testGetDynaClassNewInstance() {
        DynaClass dynaClass = this.createBean(false).getDynaClass();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((DynaClass)dynaClass).newInstance());
    }

    @Test
    public void testGetIndexedProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(false);
        this.wrapBean.setIndexedProperty(3, 20121117);
        Assertions.assertEquals((Object)20121117, (Object)PropertyUtils.getIndexedProperty((Object)bean, (String)"indexedProperty", (int)3));
    }

    @Test
    public void testGetMappedProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(true);
        String key = "testKey";
        String value = "Hello World";
        this.wrapDynaBean.set(MAPPED_PROPERTY, "testKey", (Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)PropertyUtils.getMappedProperty((Object)bean, (String)MAPPED_PROPERTY, (String)"testKey"));
    }

    @Test
    public void testGetPropertyUnknown() {
        MultiWrapDynaBean bean = this.createBean(false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> bean.get("unknown property"));
    }

    @Test
    public void testGetSimpleProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(false);
        String text = "testText";
        this.wrapBean.setText("testText");
        Assertions.assertEquals((Object)"testText", (Object)PropertyUtils.getProperty((Object)bean, (String)"text"));
    }

    @Test
    public void testOrderOfProperties() throws Exception {
        ArrayList<Object> beans = new ArrayList<Object>();
        this.params = new BasicBuilderParameters();
        beans.add(this.params);
        beans.add(new FileBasedBuilderParametersImpl());
        for (int i = 0; i < 32; ++i) {
            beans.add(new BasicBuilderParameters());
        }
        MultiWrapDynaBean bean = new MultiWrapDynaBean(beans);
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler('+');
        PropertyUtils.setProperty((Object)bean, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        PropertyUtils.setProperty((Object)bean, (String)"listDelimiterHandler", (Object)listHandler);
        Map map = this.params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)listHandler, map.get("listDelimiterHandler"));
    }

    @Test
    public void testRemove() {
        MultiWrapDynaBean bean = this.createBean(false);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> bean.remove(MAPPED_PROPERTY, "someKey"));
    }

    @Test
    public void testSetIndexedProperty() throws Exception {
        PropertyUtils.setIndexedProperty((Object)this.createBean(false), (String)"indexedProperty", (int)1, (Object)42);
        Assertions.assertEquals((int)42, (int)this.wrapBean.getIndexedProperty(1));
    }

    @Test
    public void testSetMappedProperty() throws Exception {
        MultiWrapDynaBean bean = this.createBean(true);
        String key = "testKey";
        String text = "Hello World";
        PropertyUtils.setMappedProperty((Object)bean, (String)MAPPED_PROPERTY, (String)"testKey", (Object)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)this.wrapDynaBean.get(MAPPED_PROPERTY, "testKey"));
    }

    @Test
    public void testSetSimpleProperty() throws Exception {
        PropertyUtils.setProperty((Object)this.createBean(false), (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        Assertions.assertEquals((Object)Boolean.TRUE, this.params.getParameters().get("throwExceptionOnMissing"));
    }

    public static class WrappedBeanTestImpl {
        private final Map<String, String> mapProperties = new HashMap<String, String>();
        private final int[] indexedValues = new int[8];
        private String text;

        public int getIndexedProperty(int idx) {
            return this.indexedValues[idx];
        }

        public String getMapProperty(String key) {
            return this.mapProperties.get(key);
        }

        public String getText() {
            return this.text;
        }

        public void setIndexedProperty(int idx, int value) {
            this.indexedValues[idx] = value;
        }

        public void setMapProperty(String key, String value) {
            this.mapProperties.put(key, value);
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

