/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlUtils;

public class BinaryStlWriter
implements Closeable {
    private final OutputStream out;
    private final ByteBuffer triangleBuffer = StlUtils.byteBuffer(50);

    public BinaryStlWriter(OutputStream out) {
        this.out = out;
    }

    public void writeHeader(byte[] headerContent, int triangleCount) {
        BinaryStlWriter.writeHeader(headerContent, triangleCount, this.out);
    }

    public void writeTriangle(Vector3D p1, Vector3D p2, Vector3D p3, Vector3D normal) {
        this.writeTriangle(p1, p2, p3, normal, 0);
    }

    public void writeTriangle(Vector3D p1, Vector3D p2, Vector3D p3, Vector3D normal, int attributeValue) {
        this.triangleBuffer.rewind();
        this.putVector(StlUtils.determineNormal(p1, p2, p3, normal));
        this.putVector(p1);
        if (StlUtils.pointsAreCounterClockwise(p1, p2, p3, normal)) {
            this.putVector(p2);
            this.putVector(p3);
        } else {
            this.putVector(p3);
            this.putVector(p2);
        }
        this.triangleBuffer.putShort((short)attributeValue);
        GeometryIOUtils.acceptUnchecked(this.out::write, (Object)this.triangleBuffer.array());
    }

    @Override
    public void close() {
        GeometryIOUtils.closeUnchecked((Closeable)this.out);
    }

    private void putVector(Vector3D vec) {
        this.triangleBuffer.putFloat((float)vec.getX());
        this.triangleBuffer.putFloat((float)vec.getY());
        this.triangleBuffer.putFloat((float)vec.getZ());
    }

    static void writeHeader(byte[] headerContent, int triangleCount, OutputStream out) {
        byte[] bytes = new byte[80];
        if (headerContent != null) {
            System.arraycopy(headerContent, 0, bytes, 0, Math.min(headerContent.length, 80));
        }
        GeometryIOUtils.acceptUnchecked(out::write, (Object)bytes);
        ByteBuffer countBuffer = StlUtils.byteBuffer(4);
        countBuffer.putInt(triangleCount);
        countBuffer.flip();
        GeometryIOUtils.acceptUnchecked(out::write, (Object)countBuffer.array());
    }
}

