/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.oned;

import java.util.Comparator;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.euclidean.twod.PolarCoordinates;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.angle.Angle;
import org.apache.commons.numbers.core.Precision;

public final class Point1S
implements Point<Point1S> {
    public static final Point1S ZERO = Point1S.of(0.0);
    public static final Point1S PI = Point1S.of(Math.PI);
    public static final Point1S NaN = Point1S.of(Double.NaN);
    public static final Comparator<Point1S> NORMALIZED_AZIMUTH_ASCENDING_ORDER = (a, b) -> {
        int cmp = 0;
        if (a != null && b != null) {
            cmp = Double.compare(a.getNormalizedAzimuth(), b.getNormalizedAzimuth());
        } else if (a != null) {
            cmp = -1;
        } else if (b != null) {
            cmp = 1;
        }
        return cmp;
    };
    private final double azimuth;
    private final double normalizedAzimuth;

    private Point1S(double azimuth, double normalizedAzimuth) {
        this.azimuth = azimuth;
        this.normalizedAzimuth = normalizedAzimuth;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getNormalizedAzimuth() {
        return this.normalizedAzimuth;
    }

    public Vector2D getVector() {
        if (this.isFinite()) {
            return PolarCoordinates.toCartesian((double)1.0, (double)this.azimuth);
        }
        return null;
    }

    public int getDimension() {
        return 1;
    }

    public boolean isNaN() {
        return Double.isNaN(this.azimuth);
    }

    public boolean isInfinite() {
        return !this.isNaN() && Double.isInfinite(this.azimuth);
    }

    public boolean isFinite() {
        return Double.isFinite(this.azimuth);
    }

    public double distance(Point1S point) {
        return Point1S.distance(this, point);
    }

    public double signedDistance(Point1S point) {
        return Point1S.signedDistance(this, point);
    }

    public Point1S above(double base) {
        if (this.isFinite()) {
            double az = Angle.Rad.normalizer((double)base).applyAsDouble(this.azimuth);
            return new Point1S(az, this.normalizedAzimuth);
        }
        throw new IllegalArgumentException("Cannot normalize azimuth value: " + this.azimuth);
    }

    public Point1S above(Point1S base) {
        return this.above(base.getAzimuth());
    }

    public Point1S antipodal() {
        double az = this.normalizedAzimuth + Math.PI;
        if (az >= Math.PI * 2) {
            az -= Math.PI * 2;
        }
        return Point1S.of(az);
    }

    public boolean eq(Point1S other, Precision.DoubleEquivalence precision) {
        double dist = this.signedDistance(other);
        return precision.eqZero(dist);
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return Double.hashCode(this.azimuth) >> 17 ^ Double.hashCode(this.normalizedAzimuth);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Point1S) {
            Point1S rhs = (Point1S)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return Double.compare(this.azimuth, rhs.azimuth) == 0 && Double.compare(this.normalizedAzimuth, rhs.normalizedAzimuth) == 0;
        }
        return false;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.getAzimuth());
    }

    public static Point1S of(double azimuth) {
        double normalizedAzimuth = PolarCoordinates.normalizeAzimuth((double)azimuth);
        return new Point1S(azimuth, normalizedAzimuth);
    }

    public static Point1S of(Angle azimuth) {
        return Point1S.of(azimuth.toRad().getAsDouble());
    }

    public static Point1S from(Vector2D vector) {
        PolarCoordinates polar = PolarCoordinates.fromCartesian((Vector2D)vector);
        double az = polar.getAzimuth();
        return new Point1S(az, az);
    }

    public static Point1S from(PolarCoordinates polar) {
        double az = polar.getAzimuth();
        return new Point1S(az, az);
    }

    public static Point1S parse(String str) {
        return (Point1S)SimpleTupleFormat.getDefault().parse(str, Point1S::of);
    }

    public static double signedDistance(Point1S p1, Point1S p2) {
        double dist = p2.normalizedAzimuth - p1.normalizedAzimuth;
        if (dist < -Math.PI) {
            dist += Math.PI * 2;
        }
        if (dist >= Math.PI) {
            dist -= Math.PI * 2;
        }
        return dist;
    }

    public static double distance(Point1S p1, Point1S p2) {
        return Math.abs(Point1S.signedDistance(p1, p2));
    }
}

