/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.util.Objects;
import org.apache.commons.imaging.common.BinaryFileParser;

public class PngChunk
extends BinaryFileParser {
    private final int length;
    private final int chunkType;
    private final int crc;
    private final byte[] bytes;
    private final boolean[] propertyBits;
    private final boolean ancillary;
    private final boolean isPrivate;
    private final boolean reserved;
    private final boolean safeToCopy;

    public PngChunk(int length, int chunkType, int crc, byte[] bytes) {
        this.bytes = (byte[])Objects.requireNonNull(bytes, "bytes").clone();
        this.length = length;
        this.chunkType = chunkType;
        this.crc = crc;
        this.propertyBits = new boolean[4];
        int shift = 24;
        int theMask = 32;
        for (int i = 0; i < this.propertyBits.length; ++i) {
            int theByte = 0xFF & chunkType >> shift;
            shift -= 8;
            this.propertyBits[i] = (theByte & 0x20) > 0;
        }
        this.ancillary = this.propertyBits[0];
        this.isPrivate = this.propertyBits[1];
        this.reserved = this.propertyBits[2];
        this.safeToCopy = this.propertyBits[3];
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public int getChunkType() {
        return this.chunkType;
    }

    public int getCrc() {
        return this.crc;
    }

    protected ByteArrayInputStream getDataStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public int getLength() {
        return this.length;
    }

    public boolean[] getPropertyBits() {
        return (boolean[])this.propertyBits.clone();
    }

    public boolean isAncillary() {
        return this.ancillary;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public boolean isSafeToCopy() {
        return this.safeToCopy;
    }
}

