/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractOriginTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class CharSequenceOriginTest
extends AbstractOriginTest<CharSequence, AbstractOrigin.CharSequenceOrigin> {
    CharSequenceOriginTest() {
    }

    private String getFixtureStringFromFile() throws IOException {
        return IOUtils.resourceToString((String)"/org/apache/commons/io/test-file-20byteslength.bin", (Charset)StandardCharsets.UTF_8);
    }

    @Override
    protected AbstractOrigin.CharSequenceOrigin newOriginRo() throws IOException {
        return new AbstractOrigin.CharSequenceOrigin((CharSequence)this.getFixtureStringFromFile());
    }

    @Override
    protected AbstractOrigin.CharSequenceOrigin newOriginRw() {
        return new AbstractOrigin.CharSequenceOrigin((CharSequence)"World");
    }

    @Override
    @Test
    void testGetFile() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetFile());
    }

    @Override
    @Test
    void testGetOutputStream() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetOutputStream());
    }

    @Override
    @Test
    void testGetPath() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetPath());
    }

    @Override
    @Test
    void testGetRandomAccessFile() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetRandomAccessFile());
    }

    @Override
    @ParameterizedTest
    @EnumSource(value=StandardOpenOption.class)
    void testGetRandomAccessFile(OpenOption openOption) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetRandomAccessFile(openOption));
    }

    @Test
    void testGetReaderIgnoreCharset() throws IOException {
        try (Reader reader = this.getOriginRo().getReader(StandardCharsets.UTF_16LE);){
            Assertions.assertNotNull((Object)reader);
            Assertions.assertEquals((Object)this.getFixtureStringFromFile(), (Object)IOUtils.toString((Reader)reader));
        }
    }

    @Test
    void testGetReaderIgnoreCharsetNull() throws IOException {
        try (Reader reader = this.getOriginRo().getReader(null);){
            Assertions.assertNotNull((Object)reader);
            Assertions.assertEquals((Object)this.getFixtureStringFromFile(), (Object)IOUtils.toString((Reader)reader));
        }
    }

    @Override
    @Test
    void testGetWriter() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testGetWriter());
    }
}

