/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.lang3.SystemProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TailerTest {
    private static final int TEST_BUFFER_SIZE = 1024;
    private static final int TEST_DELAY_MILLIS = 1500;
    @TempDir
    public static File temporaryFolder;

    TailerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFile(File file, long size) throws IOException {
        Assertions.assertTrue((boolean)file.getParentFile().exists(), () -> "Cannot create file " + file + " as the parent directory does not exist");
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, size);
        }
        RandomAccessFile reader = null;
        try {
            while (reader == null) {
                try {
                    reader = RandomAccessFileMode.READ_ONLY.create(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                TestUtils.sleepQuietly(200L);
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertEquals((long)size, (long)file.length());
    }

    private List<String> expectLinesWithLongTimeout(TestTailerListener listener, long minDelay, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            TestUtils.sleep(minDelay);
            List<String> lines = listener.getLines();
            if (lines.size() <= 0) continue;
            return lines;
        }
        Assertions.fail((String)("Waiting for TestTailerListener.getLines() timed out after " + (long)count * minDelay + " ms"));
        return null;
    }

    @Test
    void testBufferBreak() throws Exception {
        long delay = 50L;
        File file = new File(temporaryFolder, "testBufferBreak.txt");
        this.createFile(file, 0L);
        this.writeStrings(file, "SBTOURIST\n");
        TestTailerListener listener = new TestTailerListener();
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 50L, false, 1);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            List<String> lines = listener.getLines();
            while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
                lines = listener.getLines();
            }
            listener.clear();
        }
    }

    @Test
    void testBuilderWithNonStandardTailable() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay-and-from-start-with-reopen-and-buffersize-and-charset.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.builder().setExecutorService(Executors.newSingleThreadExecutor()).setTailable((Tailer.Tailable)new NonStandardTailable(file)).setTailerListener((TailerListener)listener).get();){
            Assertions.assertTrue((boolean)(tailer.getTailable() instanceof NonStandardTailable));
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreate() throws Exception {
        File file = new File(temporaryFolder, "tailer-create.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreateWithDelay() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)1500L);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreateWithDelayAndFromStart() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay-and-from-start.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)1500L, (boolean)false);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreateWithDelayAndFromStartWithBufferSize() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay-and-from-start-with-buffersize.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)1500L, (boolean)false, (int)1024);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreateWithDelayAndFromStartWithReopenAndBufferSize() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay-and-from-start-with-reopen-and-buffersize.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)1500L, (boolean)false, (boolean)true, (int)1024);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreateWithDelayAndFromStartWithReopenAndBufferSizeAndCharset() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay-and-from-start-with-reopen-and-buffersize-and-charset.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (Charset)StandardCharsets.UTF_8, (TailerListener)listener, (long)1500L, (boolean)false, (boolean)true, (int)1024);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testCreatorWithDelayAndFromStartWithReopen() throws Exception {
        File file = new File(temporaryFolder, "tailer-create-with-delay-and-from-start-with-reopen.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)1500L, (boolean)false, (boolean)false);){
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testInterrupt() throws Exception {
        File file = new File(temporaryFolder, "nosuchfile");
        Assertions.assertFalse((boolean)file.exists(), (String)"nosuchfile should not exist");
        TestTailerListener listener = new TestTailerListener();
        int delay = 1000;
        int idle = 50;
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 1000L, false, 8192);){
            Thread thread = new Thread((Runnable)tailer);
            thread.setDaemon(true);
            thread.start();
            TestUtils.sleep(50L);
            thread.interrupt();
            TestUtils.sleep(1050L);
            Assertions.assertNotNull((Object)listener.exception, (String)"Missing InterruptedException");
            Assertions.assertTrue((boolean)(listener.exception instanceof InterruptedException), (String)("Unexpected Exception: " + listener.exception));
            Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
            Assertions.assertTrue((listener.notFound > 0 ? 1 : 0) != 0, (String)"fileNotFound should be called");
            Assertions.assertEquals((int)0, (int)listener.rotated, (String)"fileRotated should be not be called");
            Assertions.assertEquals((int)0, (int)listener.reachedEndOfFile, (String)"end of file never reached");
        }
    }

    @Test
    void testIO335() throws Exception {
        long delayMillis = 50L;
        File file = new File(temporaryFolder, "tailer-testio334.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 50L, false);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.writeStrings(file, "CRLF\r\n", "LF\n", "CR\r", "CRCR\r\r", "trail");
            long testDelayMillis = 500L;
            TestUtils.sleep(500L);
            List<String> lines = listener.getLines();
            Assertions.assertEquals((int)4, (int)lines.size(), (String)"line count");
            Assertions.assertEquals((Object)"CRLF", (Object)lines.get(0), (String)"line 1");
            Assertions.assertEquals((Object)"LF", (Object)lines.get(1), (String)"line 2");
            Assertions.assertEquals((Object)"CR", (Object)lines.get(2), (String)"line 3");
            Assertions.assertEquals((Object)"CRCR\r", (Object)lines.get(3), (String)"line 4");
        }
    }

    @Test
    void testLongFile() throws Exception {
        long delay = 50L;
        File file = new File(temporaryFolder, "testLongFile.txt");
        this.createFile(file, 0L);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardOpenOption.APPEND);){
            for (int i = 0; i < 100000; ++i) {
                writer.write("LineLineLineLineLineLineLineLineLineLine\n");
            }
            writer.write("SBTOURIST\n");
        }
        TestTailerListener listener = new TestTailerListener();
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 50L, false);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            List<String> lines = listener.getLines();
            while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
                lines = listener.getLines();
            }
            listener.clear();
        }
    }

    @Test
    void testMultiByteBreak() throws Exception {
        long delay = 50L;
        File origin = TestResources.getFile("test-file-utf8.bin");
        File file = new File(temporaryFolder, "testMultiByteBreak.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = SystemProperties.getOsName();
        boolean isWindows = osname.startsWith("Windows");
        Charset charsetUTF8 = StandardCharsets.UTF_8;
        try (Tailer tailer = new Tailer(file, charsetUTF8, (TailerListener)listener, 50L, false, isWindows, 8192);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            try (OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), charsetUTF8);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(origin.toPath(), new OpenOption[0]), charsetUTF8));){
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    out.write(line);
                    out.write("\n");
                    lines.add(line);
                }
                ((Writer)out).close();
                long testDelayMillis = 500L;
                TestUtils.sleep(500L);
                List<String> tailerlines = listener.getLines();
                Assertions.assertEquals((int)lines.size(), (int)tailerlines.size(), (String)"line count");
                int len = lines.size();
                for (int i = 0; i < len; ++i) {
                    String actual;
                    String expected = (String)lines.get(i);
                    if (expected.equals(actual = tailerlines.get(i))) continue;
                    Assertions.fail((String)("Line: " + i + "\nExp: (" + expected.length() + ") " + expected + "\nAct: (" + actual.length() + ") " + actual));
                }
            }
        }
    }

    @Test
    void testSimpleConstructor() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, (TailerListener)listener);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testSimpleConstructorWithDelay() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor-with-delay.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 1500L);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testSimpleConstructorWithDelayAndFromStart() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor-with-delay-and-from-start.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 1500L, false);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testSimpleConstructorWithDelayAndFromStartWithBufferSize() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor-with-delay-and-from-start-with-buffersize.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 1500L, false, 1024);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testSimpleConstructorWithDelayAndFromStartWithReopen() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor-with-delay-and-from-start-with-reopen.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 1500L, false, false);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testSimpleConstructorWithDelayAndFromStartWithReopenAndBufferSize() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor-with-delay-and-from-start-with-reopen-and-buffersize.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 1500L, false, true, 1024);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testSimpleConstructorWithDelayAndFromStartWithReopenAndBufferSizeAndCharset() throws Exception {
        File file = new File(temporaryFolder, "tailer-simple-constructor-with-delay-and-from-start-with-reopen-and-buffersize-and-charset.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener(1);
        try (Tailer tailer = new Tailer(file, StandardCharsets.UTF_8, (TailerListener)listener, 1500L, false, true, 1024);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.validateTailer(listener, file);
        }
    }

    @Test
    void testStopWithNoFile() throws Exception {
        File file = new File(temporaryFolder, "nosuchfile");
        Assertions.assertFalse((boolean)file.exists(), (String)"nosuchfile should not exist");
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        try (Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)100L, (boolean)false);){
            TestUtils.sleep(50L);
        }
        TestUtils.sleep(150L);
        if (listener.exception != null) {
            listener.exception.printStackTrace();
        }
        Assertions.assertNull((Object)listener.exception, (String)"Should not generate Exception");
        Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
        Assertions.assertTrue((listener.notFound > 0 ? 1 : 0) != 0, (String)"fileNotFound should be called");
        Assertions.assertEquals((int)0, (int)listener.rotated, (String)"fileRotated should be not be called");
        Assertions.assertEquals((int)0, (int)listener.reachedEndOfFile, (String)"end of file never reached");
    }

    @Test
    void testStopWithNoFileUsingExecutor() throws Exception {
        File file = new File(temporaryFolder, "nosuchfile");
        Assertions.assertFalse((boolean)file.exists(), (String)"nosuchfile should not exist");
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 100L, false);){
            ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);
            exec.execute((Runnable)tailer);
            TestUtils.sleep(50L);
        }
        TestUtils.sleep(150L);
        Assertions.assertNull((Object)listener.exception, (String)"Should not generate Exception");
        Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
        Assertions.assertTrue((listener.notFound > 0 ? 1 : 0) != 0, (String)"fileNotFound should be called");
        Assertions.assertEquals((int)0, (int)listener.rotated, (String)"fileRotated should be not be called");
        Assertions.assertEquals((int)0, (int)listener.reachedEndOfFile, (String)"end of file never reached");
    }

    @Test
    void testTailer() throws Exception {
        long delayMillis = 50L;
        File file = new File(temporaryFolder, "tailer1-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = SystemProperties.getOsName();
        boolean isWindows = osname.startsWith("Windows");
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 50L, false, isWindows);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.writeLines(file, "Line one", "Line two");
            long testDelayMillis = 500L;
            TestUtils.sleep(500L);
            List<String> lines = listener.getLines();
            Assertions.assertEquals((int)2, (int)lines.size(), (String)"1 line count");
            Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
            Assertions.assertEquals((Object)"Line two", (Object)lines.get(1), (String)"1 line 2");
            listener.clear();
            this.writeLines(file, "Line three");
            TestUtils.sleep(500L);
            lines = listener.getLines();
            Assertions.assertEquals((int)1, (int)lines.size(), (String)"2 line count");
            Assertions.assertEquals((Object)"Line three", (Object)lines.get(0), (String)"2 line 3");
            listener.clear();
            lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((int)3, (int)lines.size(), (String)"3 line count");
            Assertions.assertEquals((Object)"Line one", lines.get(0), (String)"3 line 1");
            Assertions.assertEquals((Object)"Line two", lines.get(1), (String)"3 line 2");
            Assertions.assertEquals((Object)"Line three", lines.get(2), (String)"3 line 3");
            file.delete();
            Assertions.assertFalse((boolean)file.exists(), (String)"File should not exist");
            this.createFile(file, 0L);
            Assertions.assertTrue((boolean)file.exists(), (String)"File should now exist");
            TestUtils.sleep(500L);
            this.writeLines(file, "Line four");
            TestUtils.sleep(500L);
            lines = listener.getLines();
            Assertions.assertEquals((int)1, (int)lines.size(), (String)"4 line count");
            Assertions.assertEquals((Object)"Line four", (Object)lines.get(0), (String)"4 line 3");
            listener.clear();
            thread.interrupt();
            TestUtils.sleep(2000L);
            this.writeLines(file, "Line five");
            Assertions.assertEquals((int)0, (int)listener.getLines().size(), (String)"4 line count");
            Assertions.assertNotNull((Object)listener.exception, (String)"Missing InterruptedException");
            Assertions.assertTrue((boolean)(listener.exception instanceof InterruptedException), (String)("Unexpected Exception: " + listener.exception));
            Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
            Assertions.assertEquals((int)1, (int)listener.rotated, (String)"fileRotated should be called");
        }
    }

    @Test
    void testTailerEndOfFileReached() throws Exception {
        long delayMillis = 50L;
        long testDelayMillis = 500L;
        File file = new File(temporaryFolder, "tailer-eof-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = SystemProperties.getOsName();
        boolean isWindows = osname.startsWith("Windows");
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 50L, false, isWindows);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.writeLines(file, "line1", "line2", "line3");
            TestUtils.sleep(500L);
            this.writeLines(file, "line4", "line5", "line6");
            TestUtils.sleep(500L);
            this.writeLines(file, "line7", "line8", "line9");
            TestUtils.sleep(500L);
            Assertions.assertTrue((listener.reachedEndOfFile >= 3 ? 1 : 0) != 0, (String)"end of file reached at least 3 times");
        }
    }

    @Test
    void testTailerEof() throws Exception {
        long delayMillis = 100L;
        File file = new File(temporaryFolder, "tailer2-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        try (Tailer tailer = new Tailer(file, (TailerListener)listener, 100L, false);){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.writeStrings(file, "Line");
            TestUtils.sleep(200L);
            List<String> lines = listener.getLines();
            Assertions.assertEquals((int)0, (int)lines.size(), (String)"1 line count");
            this.writeStrings(file, " one\n");
            TestUtils.sleep(400L);
            lines = listener.getLines();
            Assertions.assertEquals((int)1, (int)lines.size(), (String)"1 line count");
            Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
            listener.clear();
        }
    }

    @Test
    void testTailerIgnoreTouch() throws Exception {
        long delayMillis = 50L;
        File file = new File(temporaryFolder, "tailer1-testIgnoreTouch.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        try (Tailer tailer = ((Tailer.Builder)Tailer.builder().setFile(file)).setTailerListener((TailerListener)listener).setDelayDuration(Duration.ofMillis(50L)).setStartThread(false).setIgnoreTouch(true).get();){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.writeLines(file, "Line one");
            List<String> lines = this.expectLinesWithLongTimeout(listener, 50L, 20);
            Assertions.assertEquals((int)1, (int)lines.size(), (String)"1 line count");
            Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
            listener.clear();
            TestUtils.sleepToNextSecond();
            file.setLastModified(System.currentTimeMillis());
            TestUtils.sleep(500L);
            lines = listener.getLines();
            Assertions.assertEquals((int)0, (int)lines.size(), (String)"nothing should have changed by touching");
        }
    }

    @Test
    void testTailerReissueOnTouch() throws Exception {
        long delayMillis = 50L;
        File file = new File(temporaryFolder, "tailer1-testReissueOnTouch.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        try (Tailer tailer = ((Tailer.Builder)Tailer.builder().setFile(file)).setTailerListener((TailerListener)listener).setDelayDuration(Duration.ofMillis(50L)).setStartThread(false).setIgnoreTouch(false).get();){
            Thread thread = new Thread((Runnable)tailer);
            thread.start();
            this.writeLines(file, "Line one");
            List<String> lines = this.expectLinesWithLongTimeout(listener, 50L, 50);
            Assertions.assertEquals((int)1, (int)lines.size(), (String)"1 line count");
            Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
            listener.clear();
            TestUtils.sleepToNextSecond();
            file.setLastModified(System.currentTimeMillis());
            lines = this.expectLinesWithLongTimeout(listener, 50L, 20);
            Assertions.assertEquals((int)1, (int)lines.size(), (String)"1 line count");
            Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
            listener.clear();
        }
    }

    private void validateTailer(TestTailerListener listener, File file) throws IOException, InterruptedException {
        this.writeLines(file, "foo");
        int timeout = 30;
        TimeUnit timeoutUnit = TimeUnit.SECONDS;
        Assertions.assertTrue((boolean)listener.awaitExpectedLines(30L, timeoutUnit), () -> String.format("await timed out after %s %s", new Object[]{30, timeoutUnit}));
        Assertions.assertEquals(listener.getLines(), Arrays.asList("foo"), (String)"lines");
    }

    private void writeLines(File file, String ... lines) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardOpenOption.APPEND);){
            for (String line : lines) {
                writer.write(line + "\n");
            }
        }
    }

    private void writeStrings(File file, String ... strings) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardOpenOption.APPEND);){
            for (String string : strings) {
                writer.write(string);
            }
        }
    }

    private static final class TestTailerListener
    extends TailerListenerAdapter {
        private final List<String> lines = Collections.synchronizedList(new ArrayList());
        private final CountDownLatch latch;
        volatile Exception exception;
        volatile int notFound;
        volatile int rotated;
        volatile int initialized;
        volatile int reachedEndOfFile;

        TestTailerListener() {
            this.latch = new CountDownLatch(1);
        }

        TestTailerListener(int expectedLines) {
            this.latch = new CountDownLatch(expectedLines);
        }

        public boolean awaitExpectedLines(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.latch.await(timeout, timeUnit);
        }

        public void clear() {
            this.lines.clear();
        }

        public void endOfFileReached() {
            ++this.reachedEndOfFile;
        }

        public void fileNotFound() {
            ++this.notFound;
        }

        public void fileRotated() {
            ++this.rotated;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void handle(Exception e) {
            this.exception = e;
        }

        public void handle(String line) {
            this.lines.add(line);
            this.latch.countDown();
        }

        public void init(Tailer tailer) {
            ++this.initialized;
        }
    }

    private static final class NonStandardTailable
    implements Tailer.Tailable {
        private final File file;

        NonStandardTailable(File file) {
            this.file = file;
        }

        public Tailer.RandomAccessResourceBridge getRandomAccess(final String mode) throws FileNotFoundException {
            return new Tailer.RandomAccessResourceBridge(){
                private final RandomAccessFile randomAccessFile;
                {
                    this.randomAccessFile = new RandomAccessFile(file, mode);
                }

                public void close() throws IOException {
                    this.randomAccessFile.close();
                }

                public long getPointer() throws IOException {
                    return this.randomAccessFile.getFilePointer();
                }

                public int read(byte[] b) throws IOException {
                    return this.randomAccessFile.read(b);
                }

                public void seek(long position) throws IOException {
                    this.randomAccessFile.seek(position);
                }
            };
        }

        public boolean isNewer(FileTime fileTime) throws IOException {
            return FileUtils.isFileNewer((File)this.file, (FileTime)fileTime);
        }

        public FileTime lastModifiedFileTime() throws IOException {
            return FileUtils.lastModifiedFileTime((File)this.file);
        }

        public long size() {
            return this.file.length();
        }
    }
}

