/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStreamTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DeferredFileOutputStreamTest
extends AbstractTempDirTest {
    private final String testString = "0123456789";
    private final byte[] testBytes = "0123456789".getBytes();

    DeferredFileOutputStreamTest() {
    }

    private static void assertDeferredInitialState(DeferredFileOutputStream out) {
        Assertions.assertTrue((boolean)out.isInMemory());
    }

    public static IntStream data() {
        return IntStream.of(1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096);
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testAboveThreshold(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testAboveThreshold", "dat", new FileAttribute[0]).toFile();
        int threshold = this.testBytes.length - 5;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertFalse((boolean)out.isInMemory());
            Assertions.assertNull((Object)out.getData());
            Assertions.assertEquals((long)testFile.length(), (long)out.getByteCount());
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testAboveThresholdGetInputStream(int initialBufferSize, @TempDir Path tempDir) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testAboveThreshold", "dat", new FileAttribute[0]).toFile();
        int threshold = this.testBytes.length - 5;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertFalse((boolean)out.isInMemory());
            Assertions.assertEquals((long)testFile.length(), (long)out.getByteCount());
            try (InputStream is = out.toInputStream();){
                Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])IOUtils.toByteArray((InputStream)is));
            }
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testAtThreshold(int initialBufferSize) throws IOException {
        int threshold = this.testBytes.length;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertTrue((boolean)out.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
            byte[] resultBytes = out.getData();
            Assertions.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
            Assertions.assertArrayEquals((byte[])resultBytes, (byte[])this.testBytes);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testBelowThreshold(int initialBufferSize) throws IOException {
        int threshold = this.testBytes.length + 42;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertTrue((boolean)out.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
            byte[] resultBytes = out.getData();
            Assertions.assertEquals((int)this.testBytes.length, (int)resultBytes.length);
            Assertions.assertArrayEquals((byte[])resultBytes, (byte[])this.testBytes);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testBelowThresholdGetInputStream(int initialBufferSize) throws IOException {
        int threshold = this.testBytes.length + 42;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertTrue((boolean)out.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
            try (InputStream is = out.toInputStream();){
                Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])IOUtils.toByteArray((InputStream)is));
            }
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testTempFileAboveThreshold(int initialBufferSize) throws IOException {
        String prefix = "commons-io-test";
        String suffix = ".out";
        int threshold = this.testBytes.length - 5;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).setPrefix("commons-io-test").setSuffix(".out").setDirectory(this.tempDirFile).setDirectory(this.tempDirPath.toFile()).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            Assertions.assertNull((Object)out.getFile(), (String)"Check File is null-A");
            Assertions.assertNull((Object)out.getPath(), (String)"Check Path is null-A");
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertFalse((boolean)out.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
            Assertions.assertNull((Object)out.getData());
            Assertions.assertNotNull((Object)out.getFile(), (String)"Check file not null");
            Assertions.assertTrue((boolean)out.getFile().exists(), (String)"Check file exists");
            Assertions.assertTrue((boolean)out.getFile().getName().startsWith("commons-io-test"), (String)"Check prefix");
            Assertions.assertTrue((boolean)out.getFile().getName().endsWith(".out"), (String)"Check suffix");
            Assertions.assertEquals((Object)this.tempDirPath, (Object)out.getPath().getParent(), (String)"Check dir");
            this.verifyResultFile(out.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testTempFileAboveThresholdPrefixOnly(int initialBufferSize) throws IOException {
        String prefix = "commons-io-test";
        String suffix = null;
        int threshold = this.testBytes.length - 5;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).setPrefix("commons-io-test").setSuffix(suffix).setDirectory((Path)null).get();){
            try {
                ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
                DeferredFileOutputStreamTest.assertDeferredInitialState(out);
                Assertions.assertNull((Object)out.getFile(), (String)"Check File is null-A");
                Assertions.assertNull((Object)out.getPath(), (String)"Check Path is null-A");
                out.write(this.testBytes, 0, this.testBytes.length);
                out.close();
                Assertions.assertFalse((boolean)out.isInMemory());
                Assertions.assertNull((Object)out.getData());
                Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
                Assertions.assertNotNull((Object)out.getFile(), (String)"Check file not null");
                Assertions.assertTrue((boolean)out.getFile().exists(), (String)"Check file exists");
                Assertions.assertTrue((boolean)out.getFile().getName().startsWith("commons-io-test"), (String)"Check prefix");
                Assertions.assertTrue((boolean)out.getFile().getName().endsWith(".tmp"), (String)"Check suffix");
                this.verifyResultFile(out.getFile());
            }
            finally {
                out.getFile().delete();
            }
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testTempFileBelowThreshold(int initialBufferSize) throws IOException {
        String prefix = "commons-io-test";
        String suffix = ".out";
        int threshold = this.testBytes.length + 42;
        try (DeferredFileOutputStream out = new DeferredFileOutputStream(threshold, initialBufferSize, "commons-io-test", ".out", this.tempDirFile);){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            Assertions.assertNull((Object)out.getFile(), (String)"Check File is null-A");
            Assertions.assertNull((Object)out.getPath(), (String)"Check Path is null-A");
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertTrue((boolean)out.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
            Assertions.assertNull((Object)out.getFile(), (String)"Check file is null-B");
        }
    }

    @Test
    void testTempFileError() throws Exception {
        String prefix = null;
        String suffix = ".out";
        Assertions.assertThrows(NullPointerException.class, () -> new DeferredFileOutputStream(this.testBytes.length - 5, prefix, ".out", this.tempDirFile));
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testThresholdNegative(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testThresholdNegative", "dat", new FileAttribute[0]).toFile();
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(-1).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, 0, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            out.write(this.testBytes, 0, this.testBytes.length);
            out.close();
            Assertions.assertFalse((boolean)out.isInMemory());
            Assertions.assertNull((Object)out.getData());
            Assertions.assertEquals((long)testFile.length(), (long)out.getByteCount());
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testThresholdReached(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testThresholdReached", "dat", new FileAttribute[0]).toFile();
        int threshold = this.testBytes.length / 2;
        try (DeferredFileOutputStream out = ((DeferredFileOutputStream.Builder)DeferredFileOutputStream.builder().setThreshold(threshold).setBufferSize(initialBufferSize)).setOutputFile(testFile).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)out, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(out);
            int chunkSize = this.testBytes.length / 3;
            out.write(this.testBytes, 0, chunkSize);
            out.write(this.testBytes, chunkSize, chunkSize);
            out.write(this.testBytes, chunkSize * 2, this.testBytes.length - chunkSize * 2);
            out.close();
            Assertions.assertFalse((boolean)out.isInMemory());
            Assertions.assertNull((Object)out.getData());
            Assertions.assertEquals((long)this.testBytes.length, (long)out.getByteCount());
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testWriteToLarge(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testWriteToFile", "dat", new FileAttribute[0]).toFile();
        int threshold = this.testBytes.length / 2;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
             DeferredFileOutputStream dfos = DeferredFileOutputStream.builder().setThreshold(threshold).setOutputFile(testFile).get();){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)dfos, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(dfos);
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)testFile.exists());
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            Assertions.assertThrows(IOException.class, () -> dfos.writeTo((OutputStream)baos));
            dfos.close();
            dfos.writeTo((OutputStream)baos);
            byte[] copiedBytes = baos.toByteArray();
            Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])copiedBytes);
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testWriteToLargeCtor(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testWriteToFile", "dat", new FileAttribute[0]).toFile();
        int threshold = this.testBytes.length / 2;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
             DeferredFileOutputStream dfos = new DeferredFileOutputStream(threshold, testFile);){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)dfos, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(dfos);
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)testFile.exists());
            Assertions.assertFalse((boolean)dfos.isInMemory());
            Assertions.assertThrows(IOException.class, () -> dfos.writeTo((OutputStream)baos));
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            dfos.close();
            dfos.writeTo((OutputStream)baos);
            byte[] copiedBytes = baos.toByteArray();
            Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])copiedBytes);
            this.verifyResultFile(testFile);
        }
    }

    @ParameterizedTest(name="initialBufferSize = {0}")
    @MethodSource(value={"data"})
    void testWriteToSmall(int initialBufferSize) throws IOException {
        File testFile = Files.createTempFile(this.tempDirPath, "testWriteToMem", "dat", new FileAttribute[0]).toFile();
        int threshold = this.testBytes.length * 2;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
             DeferredFileOutputStream dfos = new DeferredFileOutputStream(threshold, initialBufferSize, testFile);){
            ThresholdingOutputStreamTest.assertThresholdingInitialState((ThresholdingOutputStream)dfos, threshold, 0);
            DeferredFileOutputStreamTest.assertDeferredInitialState(dfos);
            dfos.write(this.testBytes);
            Assertions.assertTrue((boolean)dfos.isInMemory());
            Assertions.assertThrows(IOException.class, () -> dfos.writeTo((OutputStream)baos));
            Assertions.assertEquals((long)this.testBytes.length, (long)dfos.getByteCount());
            dfos.close();
            dfos.writeTo((OutputStream)baos);
            byte[] copiedBytes = baos.toByteArray();
            Assertions.assertArrayEquals((byte[])this.testBytes, (byte[])copiedBytes);
        }
    }

    private void verifyResultFile(File testFile) throws IOException {
        try (InputStream fis = Files.newInputStream(testFile.toPath(), new OpenOption[0]);){
            Assertions.assertEquals((int)this.testBytes.length, (int)fis.available());
            byte[] resultBytes = new byte[this.testBytes.length];
            Assertions.assertEquals((int)this.testBytes.length, (int)fis.read(resultBytes));
            Assertions.assertArrayEquals((byte[])resultBytes, (byte[])this.testBytes);
            Assertions.assertEquals((int)-1, (int)fis.read(resultBytes));
        }
    }
}

