/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractOriginTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class URIOriginTest
extends AbstractOriginTest<URI, AbstractOrigin.URIOrigin> {
    URIOriginTest() {
    }

    @Override
    protected AbstractOrigin.URIOrigin newOriginRo() {
        return new AbstractOrigin.URIOrigin(Paths.get("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin", new String[0]).toUri());
    }

    @Override
    protected AbstractOrigin.URIOrigin newOriginRw() {
        return new AbstractOrigin.URIOrigin(Paths.get(FILE_NAME_RW, new String[0]).toUri());
    }

    @ParameterizedTest
    @ValueSource(strings={"http://example.com", "https://example.com"})
    void testGetInputStream(String uri) throws Exception {
        AbstractOrigin.URIOrigin origin = new AbstractOrigin.URIOrigin(new URI(uri));
        try (InputStream in = origin.getInputStream(new OpenOption[0]);){
            Assertions.assertNotEquals((int)-1, (int)in.read());
        }
    }

    @Test
    void testGetInputStreamFileURI() throws Exception {
        AbstractOrigin.URIOrigin origin = (AbstractOrigin.URIOrigin)this.getOriginRo().asThis();
        try (InputStream in = origin.getInputStream(new OpenOption[0]);){
            Assertions.assertNotEquals((int)-1, (int)in.read());
        }
    }
}

