/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ExceptionWrapperHandler<T>
implements InvocationHandler {
    private final T delegate;
    private final Constructor<? extends RuntimeException> wrapper;

    public ExceptionWrapperHandler(T delegate, Class<? extends RuntimeException> exceptionType) {
        this.delegate = delegate;
        try {
            this.wrapper = exceptionType.getConstructor(Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getCause();
            if (RuntimeException.class.isInstance(e)) {
                RuntimeException re;
                try {
                    re = this.wrapper.newInstance(e);
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException(e1);
                }
                throw re;
            }
            throw e;
        }
    }

    public static <T> T newProxy(ClassLoader loader, T delegate, Class<? extends RuntimeException> exceptionType, Class<T> apis) {
        return (T)Proxy.newProxyInstance(loader, new Class[]{apis}, new ExceptionWrapperHandler<T>(delegate, exceptionType));
    }
}

