/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;

public class LateralCacheNoWaitFacadeUnitTest
extends TestCase {
    private LateralCacheNoWaitFacade<String, String> facade;
    private LateralCache<String, String> cache;

    protected void setUp() throws Exception {
        ArrayList noWaits = new ArrayList();
        TCPLateralCacheAttributes cattr = new TCPLateralCacheAttributes();
        cattr.setCacheName("testCache1");
        cattr.setTcpServer("localhost:7890");
        this.facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        this.cache = new LateralCache((ILateralCacheAttributes)cattr, (ICacheServiceNonLocal)new ZombieCacheServiceNonLocal(), null);
    }

    public void testAddThenRemoveNoWait_InList() {
        LateralCacheNoWait noWait = new LateralCacheNoWait(this.cache);
        this.facade.addNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)this.facade.containsNoWait(noWait));
        this.facade.removeNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have 0", (int)0, (int)this.facade.getNoWaitSize());
        LateralCacheNoWaitFacadeUnitTest.assertFalse((String)"Should not be in the list. ", (boolean)this.facade.containsNoWait(noWait));
    }

    public void testAddThenRemoveNoWait_InListSize2() {
        LateralCacheNoWait noWait = new LateralCacheNoWait(this.cache);
        noWait.setIdentityKey("1234");
        LateralCacheNoWait noWait2 = new LateralCacheNoWait(this.cache);
        noWait2.setIdentityKey("2345");
        this.facade.addNoWait(noWait);
        this.facade.addNoWait(noWait2);
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have 2", (int)2, (int)this.facade.getNoWaitSize());
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)this.facade.containsNoWait(noWait));
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)this.facade.containsNoWait(noWait2));
        this.facade.removeNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should only have 1", (int)1, (int)this.facade.getNoWaitSize());
        LateralCacheNoWaitFacadeUnitTest.assertFalse((String)"Should not be in the list. ", (boolean)this.facade.containsNoWait(noWait));
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)this.facade.containsNoWait(noWait2));
    }

    public void testAdd_InList() {
        LateralCacheNoWait noWait = new LateralCacheNoWait(this.cache);
        this.facade.addNoWait(noWait);
        this.facade.addNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)this.facade.containsNoWait(noWait));
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should only have 1", (int)1, (int)this.facade.getNoWaitSize());
    }

    public void testAddThenRemoveNoWait_NotInList() {
        LateralCacheNoWait noWait = new LateralCacheNoWait(this.cache);
        this.facade.removeNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertFalse((String)"Should not be in the list.", (boolean)this.facade.containsNoWait(noWait));
    }
}

