/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheDispatcher;
import org.apache.commons.jcs3.auxiliary.remote.http.client.MockRemoteCacheDispatcher;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteRequestType;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class RemoteHttpCacheClientUnitTest
extends TestCase {
    public void testGet_nullFromDispatcher() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        String key = "key";
        mockDispatcher.setupRemoteCacheResponse = null;
        ICacheElement result = client.get("test", (Object)"key");
        RemoteHttpCacheClientUnitTest.assertNull((String)"Wrong result.", (Object)result);
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.GET, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testGet_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        String key = "key";
        CacheElement expected = new CacheElement("test", (Object)"key", (Object)"value");
        RemoteCacheResponse remoteHttpCacheResponse = new RemoteCacheResponse();
        remoteHttpCacheResponse.setPayload((Object)expected);
        mockDispatcher.setupRemoteCacheResponse = remoteHttpCacheResponse;
        ICacheElement result = client.get("test", (Object)"key");
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong result.", (Object)expected, (Object)result);
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.GET, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testGetMatching_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        String pattern = "key";
        CacheElement expected = new CacheElement("test", (Object)"key", (Object)"value");
        HashMap<String, CacheElement> expectedMap = new HashMap<String, CacheElement>();
        expectedMap.put("key", expected);
        RemoteCacheResponse remoteHttpCacheResponse = new RemoteCacheResponse();
        remoteHttpCacheResponse.setPayload(expectedMap);
        mockDispatcher.setupRemoteCacheResponse = remoteHttpCacheResponse;
        Map result = client.getMatching("test", "key");
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong result.", (Object)expected, result.get("key"));
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.GET_MATCHING, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testGetMultiple_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        Set keys = Collections.emptySet();
        CacheElement expected = new CacheElement("test", (Object)"key", (Object)"value");
        HashMap<String, CacheElement> expectedMap = new HashMap<String, CacheElement>();
        expectedMap.put("key", expected);
        RemoteCacheResponse remoteHttpCacheResponse = new RemoteCacheResponse();
        remoteHttpCacheResponse.setPayload(expectedMap);
        mockDispatcher.setupRemoteCacheResponse = remoteHttpCacheResponse;
        Map result = client.getMultiple("test", keys);
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong result.", (Object)expected, result.get("key"));
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.GET_MULTIPLE, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testRemove_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        String key = "key";
        client.remove("test", (Object)"key");
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.REMOVE, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testRemoveAll_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        client.removeAll("test");
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.REMOVE_ALL, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testUpdate_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        CacheElement element = new CacheElement("test", (Object)"key", (Object)"value");
        client.update((ICacheElement)element);
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.UPDATE, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }

    public void testDispose_normal() throws IOException {
        RemoteHttpCacheAttributes attributes = new RemoteHttpCacheAttributes();
        RemoteHttpCacheClient client = new RemoteHttpCacheClient(attributes);
        MockRemoteCacheDispatcher mockDispatcher = new MockRemoteCacheDispatcher();
        client.setRemoteDispatcher((IRemoteCacheDispatcher)mockDispatcher);
        String cacheName = "test";
        client.dispose("test");
        RemoteHttpCacheClientUnitTest.assertEquals((String)"Wrong type.", (Object)RemoteRequestType.DISPOSE, (Object)mockDispatcher.lastRemoteCacheRequest.getRequestType());
    }
}

