/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.impl.TagLibraryResolver;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTagLibraryResolver
implements TagLibraryResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$impl$DefaultTagLibraryResolver == null ? (class$org$apache$commons$jelly$impl$DefaultTagLibraryResolver = DefaultTagLibraryResolver.class$("org.apache.commons.jelly.impl.DefaultTagLibraryResolver")) : class$org$apache$commons$jelly$impl$DefaultTagLibraryResolver));
    private DiscoverClasses discovery;
    private ClassLoader classLoader;
    private boolean useContextClassLoader = false;
    static /* synthetic */ Class class$org$apache$commons$jelly$impl$DefaultTagLibraryResolver;
    static /* synthetic */ Class class$org$apache$commons$jelly$TagLibrary;

    public TagLibrary resolveTagLibrary(String uri) {
        DiscoverClasses discovery = this.getDiscoverClasses();
        String name = uri;
        if (uri.startsWith("jelly:")) {
            name = "jelly." + uri.substring(6);
        }
        log.info((Object)("Looking up service name: " + name));
        ResourceClassIterator iter = discovery.findResourceClasses(name);
        while (iter.hasNext()) {
            ResourceClass resource = iter.nextResourceClass();
            try {
                Class typeClass = resource.loadClass();
                if (typeClass == null) continue;
                return this.newInstance(uri, typeClass);
            }
            catch (Exception e) {
                log.error((Object)("Could not load service: " + resource));
            }
        }
        log.info((Object)("Could not find any services for name: " + name));
        return null;
    }

    public ClassLoader getClassLoader() {
        return ClassLoaderUtils.getClassLoader(this.classLoader, this.useContextClassLoader, this.getClass());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public DiscoverClasses getDiscoverClasses() {
        if (this.discovery == null) {
            ClassLoaders loaders = ClassLoaders.getAppLoaders((Class)(class$org$apache$commons$jelly$TagLibrary == null ? (class$org$apache$commons$jelly$TagLibrary = DefaultTagLibraryResolver.class$("org.apache.commons.jelly.TagLibrary")) : class$org$apache$commons$jelly$TagLibrary), this.getClass(), (boolean)false);
            this.discovery = new DiscoverClasses(loaders);
        }
        return this.discovery;
    }

    public void setDiscoverClasses(DiscoverClasses discovery) {
        this.discovery = discovery;
    }

    protected TagLibrary loadClass(String uri, String className) {
        try {
            Class<?> theClass = this.getClassLoader().loadClass(className);
            if (theClass != null) {
                return this.newInstance(uri, theClass);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find the class: " + className + " when trying to resolve URI: " + uri), (Throwable)e);
        }
        return null;
    }

    protected TagLibrary newInstance(String uri, Class theClass) {
        try {
            Object object = theClass.newInstance();
            if (object instanceof TagLibrary) {
                return (TagLibrary)object;
            }
            log.error((Object)("The tag library object mapped to: " + uri + " is not a TagLibrary. Object = " + object));
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate instance of class: " + theClass.getName() + ". Reason: " + e), (Throwable)e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

