/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.junit.Asserter;

public class BitwiseOperatorTest
extends JexlTestCase {
    private Asserter asserter;

    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    public BitwiseOperatorTest(String name) {
        super(name);
    }

    public void testAndWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null & null", new Long(0L));
    }

    public void testAndWithLeftNull() throws Exception {
        this.asserter.assertExpression("null & 1", new Long(0L));
    }

    public void testAndWithRightNull() throws Exception {
        this.asserter.assertExpression("1 & null", new Long(0L));
    }

    public void testAndSimple() throws Exception {
        this.asserter.assertExpression("15 & 3", new Long(3L));
    }

    public void testAndVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(15));
        this.asserter.setVariable("y", new Short(7));
        this.asserter.assertExpression("x & y", new Long(7L));
    }

    public void testAndVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(15));
        this.asserter.setVariable("y", "7");
        this.asserter.assertExpression("x & y", new Long(7L));
    }

    public void testComplementWithNull() throws Exception {
        this.asserter.assertExpression("~null", new Long(-1L));
    }

    public void testComplementSimple() throws Exception {
        this.asserter.assertExpression("~128", new Long(-129L));
    }

    public void testComplementVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(15));
        this.asserter.assertExpression("~x", new Long(-16L));
    }

    public void testComplementVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", "15");
        this.asserter.assertExpression("~x", new Long(-16L));
    }

    public void testOrWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null | null", new Long(0L));
    }

    public void testOrWithLeftNull() throws Exception {
        this.asserter.assertExpression("null | 1", new Long(1L));
    }

    public void testOrWithRightNull() throws Exception {
        this.asserter.assertExpression("1 | null", new Long(1L));
    }

    public void testOrSimple() throws Exception {
        this.asserter.assertExpression("12 | 3", new Long(15L));
    }

    public void testOrVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(12));
        this.asserter.setVariable("y", new Short(3));
        this.asserter.assertExpression("x | y", new Long(15L));
    }

    public void testOrVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(12));
        this.asserter.setVariable("y", "3");
        this.asserter.assertExpression("x | y", new Long(15L));
    }

    public void testXorWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null ^ null", new Long(0L));
    }

    public void testXorWithLeftNull() throws Exception {
        this.asserter.assertExpression("null ^ 1", new Long(1L));
    }

    public void testXorWithRightNull() throws Exception {
        this.asserter.assertExpression("1 ^ null", new Long(1L));
    }

    public void testXorSimple() throws Exception {
        this.asserter.assertExpression("1 ^ 3", new Long(2L));
    }

    public void testXorVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(1));
        this.asserter.setVariable("y", new Short(3));
        this.asserter.assertExpression("x ^ y", new Long(2L));
    }

    public void testXorVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(1));
        this.asserter.setVariable("y", "3");
        this.asserter.assertExpression("x ^ y", new Long(2L));
    }

    public void testParenthesized() throws Exception {
        this.asserter.assertExpression("(2 | 1) & 3", 3L);
        this.asserter.assertExpression("(2 & 1) | 3", 3L);
        this.asserter.assertExpression("~(120 | 42)", new Long(-123L));
    }
}

