/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.NamespaceResolver;
import org.apache.commons.jexl2.ReadonlyContext;
import org.apache.commons.jexl2.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarTest
extends JexlTestCase {
    static final Logger LOGGER = Logger.getLogger(VarTest.class.getName());

    public VarTest(String testName) {
        super(testName);
    }

    public void testStrict() throws Exception {
        Object o;
        MapContext map = new MapContext();
        ReadonlyContext ctxt = new ReadonlyContext((JexlContext)new MapContext());
        this.JEXL.setStrict(true);
        Script e = this.JEXL.createScript("x");
        try {
            o = e.execute((JexlContext)ctxt);
            VarTest.fail((String)"should have thrown an unknown var exception");
        }
        catch (JexlException xjexl) {
            // empty catch block
        }
        e = this.JEXL.createScript("x = 42");
        try {
            o = e.execute((JexlContext)ctxt);
            VarTest.fail((String)"should have thrown a readonly context exception");
        }
        catch (JexlException xjexl) {
            // empty catch block
        }
        map.set("x", (Object)"fourty-two");
        e = this.JEXL.createScript("x.theAnswerToEverything()");
        try {
            o = e.execute((JexlContext)ctxt);
            VarTest.fail((String)"should have thrown an unknown method exception");
        }
        catch (JexlException xjexl) {
            // empty catch block
        }
    }

    public void testLocalBasic() throws Exception {
        Script e = this.JEXL.createScript("var x; x = 42");
        Object o = e.execute(null);
        VarTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    public void testLocalSimple() throws Exception {
        Script e = this.JEXL.createScript("var x = 21; x + x");
        Object o = e.execute(null);
        VarTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    public void testLocalFor() throws Exception {
        Script e = this.JEXL.createScript("var y  = 0; for(var x : [5, 17, 20]) { y = y + x; } y;");
        Object o = e.execute(null);
        VarTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    public void testLocalForFunc() throws Exception {
        NumbersContext jc = new NumbersContext();
        Script e = this.JEXL.createScript("var y  = 0; for(var x : numbers()) { y = y + x; } y;");
        Object o = e.execute((JexlContext)jc);
        VarTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    public void testLocalForFuncReturn() throws Exception {
        NumbersContext jc = new NumbersContext();
        Script e = this.JEXL.createScript("var y  = 42; for(var x : numbers()) { if (x > 10) return x } y;");
        Object o = e.execute((JexlContext)jc);
        VarTest.assertEquals((String)"Result is not 17", (Object)new Integer(17), (Object)o);
        VarTest.assertTrue((String)this.toString(e.getVariables()), (boolean)e.getVariables().isEmpty());
    }

    String toString(Set<List<String>> refs) {
        StringBuilder strb = new StringBuilder("{");
        int r = 0;
        for (List<String> strs : refs) {
            if (r++ > 0) {
                strb.append(", ");
            }
            strb.append("{");
            for (int s = 0; s < strs.size(); ++s) {
                if (s > 0) {
                    strb.append(", ");
                }
                strb.append('\"');
                strb.append(strs.get(s));
                strb.append('\"');
            }
            strb.append("}");
        }
        strb.append("}");
        return strb.toString();
    }

    Set<List<String>> mkref(String[][] refs) {
        HashSet<List<String>> set = new HashSet<List<String>>();
        for (String[] ref : refs) {
            set.add(Arrays.asList(ref));
        }
        return set;
    }

    boolean eq(Set<List<String>> lhs, Set<List<String>> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        List<String> llhs = this.stringify(lhs);
        List<String> lrhs = this.stringify(rhs);
        for (int s = 0; s < llhs.size(); ++s) {
            String r;
            String l = llhs.get(s);
            if (l.equals(r = lrhs.get(s))) continue;
            return false;
        }
        return true;
    }

    List<String> stringify(Set<List<String>> sls) {
        ArrayList<String> ls = new ArrayList<String>();
        for (List<String> l : sls) {
            StringBuilder strb = new StringBuilder();
            for (String s : l) {
                strb.append(s);
                strb.append('|');
            }
            ls.add(strb.toString());
        }
        Collections.sort(ls);
        return ls;
    }

    public void testRefs() throws Exception {
        Script e = this.JEXL.createScript("e[f]");
        Set vars = e.getVariables();
        Set<List<String>> expect = this.mkref(new String[][]{{"e"}, {"f"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e[f][g]");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e"}, {"f"}, {"g"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e['f'].goo");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e", "f", "goo"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e['f']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e", "f"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e[f]['g']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e"}, {"f"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("e['f']['g']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"e", "f", "g"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a['b'].c['d'].e");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a", "b", "c", "d", "e"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
        e = this.JEXL.createScript("a + b.c + b.c.d + e['f']");
        vars = e.getVariables();
        expect = this.mkref(new String[][]{{"a"}, {"b", "c"}, {"b", "c", "d"}, {"e", "f"}});
        VarTest.assertTrue((boolean)this.eq(expect, vars));
    }

    public void testMix() throws Exception {
        Script e = this.JEXL.createScript("if (x) { y } else { var z = 2 * x}", new String[]{"x"});
        Set vars = e.getVariables();
        String[] parms = e.getParameters();
        String[] locals = e.getLocalVariables();
        VarTest.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"y"}}), vars));
        VarTest.assertEquals((int)1, (int)parms.length);
        VarTest.assertEquals((String)"x", (String)parms[0]);
        VarTest.assertEquals((int)1, (int)locals.length);
        VarTest.assertEquals((String)"z", (String)locals[0]);
    }

    public void testLiteral() throws Exception {
        Script e = this.JEXL.createScript("x.y[['z', 't']]");
        Set vars = e.getVariables();
        VarTest.assertEquals((int)1, (int)vars.size());
        VarTest.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "[ 'z', 't' ]"}}), vars));
        e = this.JEXL.createScript("x.y[{'z': 't'}]");
        vars = e.getVariables();
        VarTest.assertEquals((int)1, (int)vars.size());
        VarTest.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "{ 'z' : 't' }"}}), vars));
        e = this.JEXL.createScript("x.y.'{ \\'z\\' : \\'t\\' }'");
        vars = e.getVariables();
        VarTest.assertEquals((int)1, (int)vars.size());
        VarTest.assertTrue((boolean)this.eq(this.mkref(new String[][]{{"x", "y", "{ 'z' : 't' }"}}), vars));
    }

    public static class NumbersContext
    extends MapContext
    implements NamespaceResolver {
        public Object resolveNamespace(String name) {
            return name == null ? this : null;
        }

        public Object numbers() {
            return new int[]{5, 17, 20};
        }
    }
}

