/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.File;
import java.net.URL;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.Script;

public class ScriptTest
extends JexlTestCase {
    static final String TEST1 = "src/test/scripts/test1.jexl";

    public ScriptTest(String name) {
        super(name);
    }

    public void testSimpleScript() throws Exception {
        String code = "while (x < 10) x = x + 1;";
        Script s = this.JEXL.createScript(code);
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        Object o = s.execute((JexlContext)jc);
        ScriptTest.assertEquals((String)"Result is wrong", (Object)new Integer(10), (Object)o);
        ScriptTest.assertEquals((String)"getText is wrong", (String)code, (String)s.getText());
    }

    public void testScriptFromFile() throws Exception {
        File testScript = new File(TEST1);
        Script s = this.JEXL.createScript(testScript);
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc);
        ScriptTest.assertNotNull((String)"No result", (Object)result);
        ScriptTest.assertEquals((String)"Wrong result", (Object)new Integer(7), (Object)result);
    }

    public void testScriptFromURL() throws Exception {
        URL testUrl = new File(TEST1).toURI().toURL();
        Script s = this.JEXL.createScript(testUrl);
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc);
        ScriptTest.assertNotNull((String)"No result", (Object)result);
        ScriptTest.assertEquals((String)"Wrong result", (Object)new Integer(7), (Object)result);
    }

    public void testScriptUpdatesContext() throws Exception {
        String jexlCode = "resultat.setCode('OK')";
        Expression e = this.JEXL.createExpression(jexlCode);
        Script s = this.JEXL.createScript(jexlCode);
        Tester resultatJexl = new Tester();
        MapContext jc = new MapContext();
        jc.set("resultat", (Object)resultatJexl);
        resultatJexl.setCode("");
        e.evaluate((JexlContext)jc);
        ScriptTest.assertEquals((String)"OK", (String)resultatJexl.getCode());
        resultatJexl.setCode("");
        s.execute((JexlContext)jc);
        ScriptTest.assertEquals((String)"OK", (String)resultatJexl.getCode());
    }

    public static class Tester {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String c) {
            this.code = c;
        }
    }
}

