/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.junit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlThreadedArithmetic;
import org.apache.commons.jexl2.MapContext;

public class Asserter
extends Assert {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final JexlContext context = new MapContext(this.variables);
    private final JexlEngine engine;

    public Asserter(JexlEngine jexl) {
        this.engine = jexl;
    }

    public JexlEngine getEngine() {
        return this.engine;
    }

    public JexlContext getContext() {
        return this.context;
    }

    public void assertExpression(String expression, Object expected) throws Exception {
        Expression exp = this.engine.createExpression(expression);
        Object value = exp.evaluate(this.context);
        if (expected instanceof BigDecimal) {
            JexlArithmetic jexla = this.engine.getArithmetic();
            Asserter.assertTrue((String)("expression: " + expression), (((BigDecimal)expected).compareTo(jexla.toBigDecimal(value)) == 0 ? 1 : 0) != 0);
        } else {
            Asserter.assertEquals((String)("expression: " + expression), (Object)expected, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failExpression(String expression, String matchException) throws Exception {
        boolean[] flags = new boolean[]{this.engine.isLenient(), this.engine.isSilent()};
        try {
            if (this.engine.getArithmetic() instanceof JexlThreadedArithmetic) {
                this.engine.setLenient(false);
            }
            this.engine.setSilent(false);
            Expression exp = this.engine.createExpression(expression);
            exp.evaluate(this.context);
            Asserter.fail((String)("expression: " + expression));
        }
        catch (JexlException xjexl) {
            if (matchException != null && !xjexl.getMessage().matches(matchException)) {
                Asserter.fail((String)("expression: " + expression + ", expected: " + matchException + ", got " + xjexl.getMessage()));
            }
        }
        finally {
            if (this.engine.getArithmetic() instanceof JexlThreadedArithmetic) {
                this.engine.setLenient(flags[0]);
            }
            this.engine.setSilent(flags[1]);
        }
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public Object removeVariable(String name) {
        return this.variables.remove(name);
    }
}

