/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.ranking;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntUnaryOperator;
import org.apache.commons.statistics.ranking.NaNStrategy;
import org.apache.commons.statistics.ranking.RankingAlgorithm;
import org.apache.commons.statistics.ranking.TiesStrategy;

public class NaturalRanking
implements RankingAlgorithm {
    private static final String NULL_NAN_STRATEGY = "nanStrategy";
    private static final String NULL_TIES_STRATEGY = "tiesStrategy";
    private static final String NULL_RANDOM_SOURCE = "randomIntFunction";
    private static final NaNStrategy DEFAULT_NAN_STRATEGY = NaNStrategy.FAILED;
    private static final TiesStrategy DEFAULT_TIES_STRATEGY = TiesStrategy.AVERAGE;
    private static final DoubleUnaryOperator ACTION_POS_INF = x -> Double.POSITIVE_INFINITY;
    private static final DoubleUnaryOperator ACTION_NEG_INF = x -> Double.NEGATIVE_INFINITY;
    private static final DoubleUnaryOperator ACTION_ERROR = operand -> {
        throw new IllegalArgumentException("Invalid data: " + operand);
    };
    private final NaNStrategy nanStrategy;
    private final TiesStrategy tiesStrategy;
    private IntUnaryOperator randomIntFunction;

    public NaturalRanking() {
        this(DEFAULT_NAN_STRATEGY, DEFAULT_TIES_STRATEGY, null);
    }

    public NaturalRanking(TiesStrategy tiesStrategy) {
        this(DEFAULT_NAN_STRATEGY, Objects.requireNonNull(tiesStrategy, NULL_TIES_STRATEGY), null);
    }

    public NaturalRanking(NaNStrategy nanStrategy) {
        this(Objects.requireNonNull(nanStrategy, NULL_NAN_STRATEGY), DEFAULT_TIES_STRATEGY, null);
    }

    public NaturalRanking(NaNStrategy nanStrategy, TiesStrategy tiesStrategy) {
        this(Objects.requireNonNull(nanStrategy, NULL_NAN_STRATEGY), Objects.requireNonNull(tiesStrategy, NULL_TIES_STRATEGY), null);
    }

    public NaturalRanking(IntUnaryOperator randomIntFunction) {
        this(DEFAULT_NAN_STRATEGY, TiesStrategy.RANDOM, Objects.requireNonNull(randomIntFunction, NULL_RANDOM_SOURCE));
    }

    public NaturalRanking(NaNStrategy nanStrategy, IntUnaryOperator randomIntFunction) {
        this(Objects.requireNonNull(nanStrategy, NULL_NAN_STRATEGY), TiesStrategy.RANDOM, Objects.requireNonNull(randomIntFunction, NULL_RANDOM_SOURCE));
    }

    private NaturalRanking(NaNStrategy nanStrategy, TiesStrategy tiesStrategy, IntUnaryOperator randomIntFunction) {
        this.nanStrategy = nanStrategy;
        this.tiesStrategy = tiesStrategy;
        this.randomIntFunction = randomIntFunction;
    }

    public NaNStrategy getNanStrategy() {
        return this.nanStrategy;
    }

    public TiesStrategy getTiesStrategy() {
        return this.tiesStrategy;
    }

    @Override
    public double[] apply(double[] data) {
        int i;
        int[] nanCount = new int[]{0};
        Object[] ranks = this.createRankData(data, nanCount);
        int nonNanSize = ranks.length - nanCount[0];
        if (nonNanSize == 0) {
            return this.nanStrategy == NaNStrategy.FIXED ? data : new double[]{};
        }
        Arrays.sort(ranks);
        int pos = 1;
        double[] out = new double[ranks.length];
        Object current = ranks[0];
        out[((DataPosition)current).getPosition()] = pos;
        IntList tiesTrace = new IntList(ranks.length);
        for (i = 1; i < nonNanSize; ++i) {
            current = ranks[i];
            Object previous = current;
            if (((DataPosition)current).compareTo((DataPosition)previous) > 0) {
                if (tiesTrace.size() != 0) {
                    this.resolveTie(out, tiesTrace, ((DataPosition)previous).getPosition());
                }
                pos = i + 1;
            } else {
                tiesTrace.add(((DataPosition)previous).getPosition());
            }
            out[((DataPosition)current).getPosition()] = pos;
        }
        if (tiesTrace.size() != 0) {
            this.resolveTie(out, tiesTrace, ((DataPosition)current).getPosition());
        }
        if (this.nanStrategy == NaNStrategy.FIXED) {
            for (i = nonNanSize; i < ranks.length; ++i) {
                out[((DataPosition)ranks[i]).getPosition()] = Double.NaN;
            }
        }
        return out;
    }

    private DataPosition[] createRankData(double[] data, int[] nanCount) {
        return this.nanStrategy == NaNStrategy.REMOVED ? NaturalRanking.createNonNaNRankData(data) : NaturalRanking.createMappedRankData(data, this.createNaNAction(nanCount));
    }

    private DoubleUnaryOperator createNaNAction(int[] nanCount) {
        switch (this.nanStrategy) {
            case MAXIMAL: {
                return ACTION_POS_INF;
            }
            case MINIMAL: {
                return ACTION_NEG_INF;
            }
            case REMOVED: 
            case FIXED: {
                return x -> {
                    nanCount[0] = nanCount[0] + 1;
                    return x;
                };
            }
            case FAILED: {
                return ACTION_ERROR;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)this.nanStrategy));
    }

    private static DataPosition[] createNonNaNRankData(double[] data) {
        DataPosition[] ranks = new DataPosition[data.length];
        int size = 0;
        for (double v : data) {
            if (Double.isNaN(v)) continue;
            ranks[size] = new DataPosition(v, size);
            ++size;
        }
        return size == data.length ? ranks : Arrays.copyOf(ranks, size);
    }

    private static DataPosition[] createMappedRankData(double[] data, DoubleUnaryOperator nanAction) {
        DataPosition[] ranks = new DataPosition[data.length];
        for (int i = 0; i < data.length; ++i) {
            double v = data[i];
            if (Double.isNaN(v)) {
                v = nanAction.applyAsDouble(v);
            }
            ranks[i] = new DataPosition(v, i);
        }
        return ranks;
    }

    private void resolveTie(double[] ranks, IntList tiesTrace, int finalIndex) {
        tiesTrace.add(finalIndex);
        double c = ranks[tiesTrace.get(0)];
        int length = tiesTrace.size();
        switch (this.tiesStrategy) {
            case AVERAGE: {
                NaturalRanking.fill(ranks, tiesTrace, (2.0 * c + (double)length - 1.0) * 0.5);
                break;
            }
            case MAXIMUM: {
                NaturalRanking.fill(ranks, tiesTrace, c + (double)length - 1.0);
                break;
            }
            case MINIMUM: {
                break;
            }
            case SEQUENTIAL: 
            case RANDOM: {
                int r = (int)c;
                if (this.tiesStrategy == TiesStrategy.RANDOM) {
                    tiesTrace.shuffle(this.getRandomIntFunction());
                }
                int size = tiesTrace.size();
                for (int i = 0; i < size; ++i) {
                    ranks[tiesTrace.get((int)i)] = r++;
                }
                break;
            }
        }
        tiesTrace.clear();
    }

    private static void fill(double[] data, IntList tiesTrace, double value) {
        int size = tiesTrace.size();
        for (int i = 0; i < size; ++i) {
            data[tiesTrace.get((int)i)] = value;
        }
    }

    private IntUnaryOperator getRandomIntFunction() {
        IntUnaryOperator r = this.randomIntFunction;
        if (r == null) {
            this.randomIntFunction = r = (IntUnaryOperator)LambdaMetafactory.metafactory(null, null, null, (I)I, nextInt(int ), (I)I)((SplittableRandom)new SplittableRandom());
        }
        return r;
    }

    private static class DataPosition
    implements Comparable<DataPosition> {
        private final double value;
        private final int position;

        DataPosition(double value, int position) {
            this.value = value;
            this.position = position;
        }

        @Override
        public int compareTo(DataPosition other) {
            return Double.compare(this.value, other.value);
        }

        int getPosition() {
            return this.position;
        }
    }

    private static class IntList {
        private final int max;
        private int size;
        private int[] data = new int[2];

        IntList(int max) {
            this.max = max;
        }

        void add(int value) {
            if (this.size == this.data.length) {
                this.data = Arrays.copyOf(this.data, (int)Math.min((long)this.max, (long)this.size * 2L));
            }
            this.data[this.size++] = value;
        }

        int get(int index) {
            return this.data[index];
        }

        int size() {
            return this.size;
        }

        void clear() {
            this.size = 0;
        }

        void shuffle(IntUnaryOperator randomIntFunction) {
            int[] array = this.data;
            for (int i = this.size; i > 1; --i) {
                IntList.swap(array, i - 1, randomIntFunction.applyAsInt(i));
            }
        }

        private static void swap(int[] array, int i, int j) {
            int tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }
}

