/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.SuffixFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SuffixFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAcceptList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(".txt");
        list.add(".bin");
        SuffixFileFilter filter = new SuffixFileFilter(list);
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.bin"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.BIN"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseInsensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(".txt");
        list.add(".bin");
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.INSENSITIVE, list);
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("TEST1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.bin"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptListIOCaseSensitive() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(".txt");
        list.add(".bin");
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.SENSITIVE, list);
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.Txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.BIN"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptString() {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{".txt", ".xxx"});
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseInsensitive() {
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.INSENSITIVE, new String[]{".txt", ".xxx"});
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }

    @Test
    public void testAcceptStringIOCaseSensitive() {
        SuffixFileFilter filter = new SuffixFileFilter(IOCase.SENSITIVE, new String[]{".txt", ".xxx"});
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test1.txt"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.txt"))));
        Assertions.assertFalse((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test2.TXT"))));
        Assertions.assertTrue((boolean)filter.accept(SuffixFileFilterTest.createFileSelectInfo(new File("test.xxx"))));
    }
}

