/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.PatternFileSelector;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class PatternFileSelectorTest {
    private static FileObject baseFolder;
    private static final int ENTRY_COUNT = 10;
    private static final int EXTENSION_COUNT = 3;
    private static final int FILES_PER_EXTENSION_COUNT = 3;

    static FileObject getBaseFolder() {
        return baseFolder;
    }

    @BeforeAll
    public static void setUpClass() throws Exception {
        baseFolder = VFS.getManager().resolveFile("ram://" + PatternFileSelectorTest.class.getName());
        baseFolder.deleteAll();
        baseFolder.createFolder();
        baseFolder.resolveFile("aa.htm").createFile();
        baseFolder.resolveFile("aa.html").createFile();
        baseFolder.resolveFile("aa.xhtml").createFile();
        baseFolder.resolveFile("b.htm").createFile();
        baseFolder.resolveFile("b.html").createFile();
        baseFolder.resolveFile("b.xhtml").createFile();
        baseFolder.resolveFile("c.htm").createFile();
        baseFolder.resolveFile("c.html").createFile();
        baseFolder.resolveFile("c.xhtml").createFile();
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (baseFolder != null) {
            baseFolder.deleteAll();
        }
    }

    @Test
    public void testFileExtensions() throws Exception {
        FileObject[] foArray = baseFolder.findFiles(Selectors.SELECT_FILES);
        Assertions.assertTrue((foArray.length > 0 ? 1 : 0) != 0);
        String regExPrefix = ".*\\.";
        HashSet<String> extensionSet = new HashSet<String>();
        for (FileObject fo : foArray) {
            extensionSet.add(".*\\." + fo.getName().getExtension());
        }
        String message = String.format("Extensions: %s; files: %s", ((Object)extensionSet).toString(), Arrays.asList(foArray).toString());
        Assertions.assertEquals((int)3, (int)extensionSet.size(), (String)message);
        for (String extension : extensionSet) {
            PatternFileSelector selector = new PatternFileSelector(extension);
            FileObject[] list = baseFolder.findFiles((FileSelector)selector);
            Assertions.assertEquals((int)3, (int)list.length);
        }
        for (FileObject fo : foArray) {
            PatternFileSelector selector = new PatternFileSelector(".*\\." + fo.getName().getExtension());
            FileObject[] list = baseFolder.findFiles((FileSelector)selector);
            Assertions.assertEquals((int)3, (int)list.length);
        }
    }

    @Test
    public void testMatchAll() throws Exception {
        FileObject[] list = baseFolder.findFiles((FileSelector)new PatternFileSelector(".*"));
        Assertions.assertEquals((int)10, (int)list.length);
    }

    @Test
    public void testMatchPartial() throws Exception {
        FileObject[] list = baseFolder.findFiles((FileSelector)new PatternFileSelector(".*a.htm"));
        Assertions.assertEquals((int)1, (int)list.length);
        Assertions.assertEquals((Object)"aa.htm", (Object)list[0].getName().getBaseName());
    }

    @Test
    public void testMatchPartialDelimited() throws Exception {
        FileObject[] list = baseFolder.findFiles((FileSelector)new PatternFileSelector("^.*\\/b.htm$"));
        Assertions.assertEquals((int)1, (int)list.length);
        Assertions.assertEquals((Object)"b.htm", (Object)list[0].getName().getBaseName());
    }

    @Test
    public void testNullString() {
        Assertions.assertThrows(NullPointerException.class, () -> new PatternFileSelector((String)null));
    }
}

