/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5s;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http5.Http5FileSystemConfigBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Http5sGetContentInfoTest {
    private static final String SERVER_JCEKS_RES = "org.apache.httpserver/star_apache_cert.ts";

    FileSystemOptions getOptionsWithProxy() throws MalformedURLException {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUrl = System.getenv("https_proxy");
        if (proxyUrl != null) {
            URL url = new URL(proxyUrl);
            proxyHost = url.getHost();
            proxyPort = url.getPort();
        }
        if (proxyHost == null || proxyPort == -1) {
            return null;
        }
        Http5FileSystemConfigBuilder builder = Http5FileSystemConfigBuilder.getInstance();
        FileSystemOptions opts = new FileSystemOptions();
        builder.setProxyHost(opts, proxyHost);
        builder.setProxyPort(opts, proxyPort);
        return opts;
    }

    private FileSystemOptions getOptionsWithSSL() throws MalformedURLException {
        Http5FileSystemConfigBuilder builder = Http5FileSystemConfigBuilder.getInstance();
        FileSystemOptions opts = this.getOptionsWithProxy();
        if (opts == null) {
            opts = new FileSystemOptions();
        }
        URL serverJksResource = ClassLoader.getSystemClassLoader().getResource(SERVER_JCEKS_RES);
        builder.setKeyStoreFile(opts, serverJksResource.getFile());
        builder.setKeyStorePass(opts, "Hello_1234");
        builder.setKeyStoreType(opts, "JCEKS");
        return opts;
    }

    @Test
    public void testGetContentInfo() throws FileSystemException, MalformedURLException {
        FileSystemManager fsManager = VFS.getManager();
        String uri = "http5://www.apache.org/licenses/LICENSE-2.0.txt";
        FileObject fo = fsManager.resolveFile("http5://www.apache.org/licenses/LICENSE-2.0.txt", this.getOptionsWithProxy());
        FileContent content = fo.getContent();
        Assertions.assertNotNull((Object)content);
        content.getContentInfo();
    }

    @Test
    public void testSSLGetContentInfo() throws IOException {
        FileSystemManager fsManager = VFS.getManager();
        String uri = "http5s://www.apache.org/licenses/LICENSE-2.0.txt";
        FileObject fo = fsManager.resolveFile("http5s://www.apache.org/licenses/LICENSE-2.0.txt", this.getOptionsWithSSL());
        FileContent content = fo.getContent();
        try (InputStream is = content.getInputStream();){
            String text = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            Assertions.assertNotNull((Object)text);
        }
    }
}

